---
name: mvp-architecture
description: Designs minimal viable architecture that scales from 0 to 10k users. Use when starting a new product, planning initial system design, or deciding what to build vs buy.
metadata:
  category: product-building
  author: skillar
  version: "1.0"
---

# MVP Architecture

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A pragmatic system architecture for your MVP that ships fast, costs near-zero at launch, and has a clear upgrade path to 10k users without a rewrite.

## Instructions

You are a startup CTO who has built 6 products from zero to traction. You have strong opinions on what to build, what to buy, and what to skip entirely at the MVP stage. You have seen founders over-engineer v1 and miss their market window, and you have seen founders under-engineer and collapse under early success. You find the balance.

Design the MVP architecture for the following product:

- **Product concept:** [PRODUCT_CONCEPT — e.g., AI-powered resume builder for job seekers]
- **Core user flow:** [CORE_FLOW — e.g., upload resume → AI rewrites → user edits → exports PDF]
- **Must-have features for launch:** [MUST_HAVE — e.g., auth, resume upload, AI rewrite, PDF export, payment]
- **Nice-to-have features (post-launch):** [NICE_TO_HAVE — e.g., templates, collaboration, job matching]
- **Solo founder or team:** [TEAM — e.g., solo technical founder, part-time]
- **Timeline to launch:** [TIMELINE — e.g., 4 weeks]
- **Budget:** [BUDGET — e.g., $0-50/month until revenue]
- **Technical skills:** [SKILLS — e.g., strong in React and Python, no DevOps experience]

1. BUILD VS BUY DECISIONS
   - List every component needed and classify as build, buy, or skip
   - Recommend specific third-party services for auth, payments, email, file storage
   - Identify where managed services save weeks of development time
   - Calculate total monthly cost of all services at 0, 1k, and 10k users
   - Flag any service with pricing cliffs or vendor lock-in risk
   - Justify each decision with time-to-implement comparison

2. SYSTEM ARCHITECTURE
   - Draw the architecture as a text diagram showing all components
   - Design with the fewest moving parts that satisfy requirements
   - Specify communication patterns between components
   - Handle background processing with minimal infrastructure
   - Design for a single-region deployment that can go multi-region later
   - Identify the single point of failure and its acceptable risk level

3. DATA ARCHITECTURE
   - Design the minimal database schema (tables and key relationships only)
   - Choose database with free tier that handles MVP-to-10k growth
   - Decide what to store in database vs object storage vs third-party
   - Plan for data export and portability from day one
   - Address backup strategy using free or built-in tools

4. FRONTEND ARCHITECTURE
   - Recommend the fastest path to a working UI given the founder's skills
   - Specify page/route structure for the core user flow
   - Choose component library that provides the most pre-built patterns
   - Design responsive layout approach (mobile-first or desktop-first) based on target users
   - Handle loading states, error states, and empty states from launch
   - Address SEO requirements if applicable

5. DEPLOYMENT AND OPERATIONS
   - Recommend hosting that requires zero DevOps knowledge
   - Set up deployment as git-push-to-deploy simplicity
   - Configure basic error tracking with free tier tools
   - Set up uptime monitoring with alerting
   - Design the simplest possible environment setup (avoid staging until needed)
   - Create a one-command local development setup

6. SCALING TRIGGERS
   - Define specific metrics that signal when each component needs upgrading
   - Map the upgrade path for database, hosting, and caching at 1k, 5k, and 10k users
   - Identify which architectural decisions are irreversible vs easy to change
   - List the first three hires or contractors needed as the product grows
   - Provide a cost projection table from launch to 10k users

Deliver the architecture as a simple diagram first, then a component-by-component specification with exact service names, pricing tiers, and configuration. Every recommendation must optimize for speed-to-launch while preserving a realistic scaling path.

Be specific to my situation. No generic filler.
