---
name: migration-plan
description: Plans database or system migration with zero-downtime strategy. Use when changing databases, migrating infrastructure, switching providers, or upgrading major versions.
metadata:
  category: product-building
  author: skillar
  version: "1.0"
---

# Migration Plan

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A detailed migration plan with phased execution steps, rollback procedures, data validation checks, and zero-downtime strategy for moving databases, services, or infrastructure safely.

## Instructions

You are a migration specialist who has executed database migrations, cloud provider switches, and major system upgrades for applications with millions of users — without downtime. You know that migrations fail not because the technical approach is wrong, but because edge cases are undiscovered and rollback plans are untested. You plan for everything to go wrong.

Plan a migration for the following scenario:

- **Migration type:** [MIGRATION_TYPE — e.g., PostgreSQL to PostgreSQL (version upgrade), MongoDB to PostgreSQL, Heroku to AWS, monolith to microservices]
- **What is being migrated:** [WHAT — e.g., main application database with 50 tables, 20M rows, 200GB]
- **Source system:** [SOURCE — e.g., Heroku PostgreSQL 12, single database, 3 connected applications]
- **Target system:** [TARGET — e.g., AWS RDS PostgreSQL 16, multi-AZ, with read replicas]
- **Downtime tolerance:** [DOWNTIME — e.g., zero downtime required, or 2-hour maintenance window acceptable]
- **Data sensitivity:** [DATA — e.g., contains PII and financial records, GDPR applicable]
- **Team resources:** [TEAM — e.g., 2 backend developers, no DBA, 1 DevOps part-time]
- **Timeline pressure:** [TIMELINE — e.g., current provider contract ends in 6 weeks]

1. MIGRATION STRATEGY SELECTION
   - Evaluate migration approaches: big bang, phased, parallel-run, strangler fig
   - Recommend the optimal approach based on downtime tolerance and complexity
   - Define the migration phases and what moves in each phase
   - Identify the point of no return and how to avoid crossing it prematurely
   - Estimate total migration timeline with buffer for unexpected issues
   - Map the risk-to-effort tradeoff for each approach option

2. PRE-MIGRATION PREPARATION
   - Audit the source system: schema, data volume, dependencies, custom extensions
   - Document all applications, services, and scripts that connect to the source
   - Identify schema changes needed for the target system compatibility
   - Set up the target environment with matching configuration
   - Create automated data validation scripts comparing source and target
   - Establish monitoring for both source and target during migration
   - Perform a full dry run on a staging copy with production-scale data

3. DATA MIGRATION EXECUTION
   - Design the initial bulk data transfer approach and tooling
   - Set up continuous replication or change data capture for delta sync
   - Handle schema transformations and data type conversions
   - Address sequence resets, auto-increment values, and ID continuity
   - Plan for large table migration that does not lock the source database
   - Handle binary data, files, and external references
   - Define batch sizes and parallelization for optimal transfer speed

4. APPLICATION CUTOVER
   - Design the traffic switching strategy (DNS, load balancer, feature flag)
   - Implement dual-write pattern if zero-downtime is required
   - Plan connection string rotation across all dependent applications
   - Handle in-flight requests and transactions during the switch
   - Define the exact sequence of operations during the cutover window
   - Coordinate cutover timing with lowest traffic period

5. VALIDATION AND VERIFICATION
   - Define data integrity checks: row counts, checksums, sample comparisons
   - Verify all application features work against the target system
   - Run performance benchmarks comparing source and target response times
   - Test all background jobs, cron tasks, and scheduled operations
   - Validate backup and recovery procedures on the target system
   - Verify monitoring and alerting is operational on the target
   - Run a security scan on the target configuration

6. ROLLBACK PLAN
   - Define rollback triggers: which failures warrant a rollback
   - Document the exact rollback procedure step by step
   - Maintain source system in rollback-ready state for a defined period
   - Handle data that was written to the target during the migration window
   - Test the rollback procedure during the dry run
   - Define the rollback decision-maker and communication protocol
   - Set the date when the source system can be safely decommissioned

Deliver the plan as a timeline with milestones, followed by detailed runbook-style procedures for each phase. Include a risk register with probability, impact, and mitigation for the top 10 risks. Every step must be reversible until the explicit point of no return.

Be specific to my situation. No generic filler.
