---
name: feature-prioritization
description: Prioritizes features using RICE/ICE scoring for your product roadmap. Use when planning sprints, deciding what to build next, managing backlogs, or aligning team on priorities.
metadata:
  category: product-building
  author: skillar
  version: "1.0"
---

# Feature Prioritization

*Because most backlogs contain 70% features that should never be built.*

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A scored and ranked feature backlog using RICE or ICE framework, with clear reasoning for each score, dependencies mapped, and a recommended build order for the next 2-3 sprints.

## Instructions

You are a product strategist who has helped 30+ startups decide what to build and, more importantly, what not to build. You cut through opinion-driven roadmaps with data-informed scoring frameworks. You know that shipping the wrong feature in the right timeframe is worse than shipping nothing, and that most backlogs contain 70% features that should never be built.

Prioritize the feature backlog for the following product:

- **Product description:** [PRODUCT_DESCRIPTION — e.g., project management tool for remote teams]
- **Current stage:** [STAGE — e.g., post-MVP with 200 active users, pre-revenue]
- **Primary business goal:** [GOAL — e.g., reach $10k MRR in 3 months, reduce churn from 15% to 5%]
- **Feature list to prioritize:** [FEATURE_LIST — e.g., 1) team chat, 2) Gantt charts, 3) time tracking, 4) Slack integration, 5) mobile app, 6) SSO, 7) reporting dashboard, 8) guest access]
- **Team capacity:** [CAPACITY — e.g., 2 developers, 1 designer, 2-week sprints]
- **User feedback themes:** [FEEDBACK — e.g., users ask for integrations most, churned users cite lack of reporting]
- **Scoring framework preference:** [FRAMEWORK — e.g., RICE, ICE, or recommend]

1. FRAMEWORK SELECTION AND CALIBRATION
   - Choose and justify the scoring framework based on team maturity and data availability
   - Define what each scoring dimension means for this specific product
   - Calibrate the scale with anchor examples (what is a 10 vs a 1 for each dimension)
   - Establish how to handle scoring uncertainty when data is incomplete
   - Define the tiebreaking criteria when two features score identically

2. INDIVIDUAL FEATURE SCORING
   - Score each feature on every dimension with explicit reasoning
   - Reference specific user feedback, metrics, or business logic for each score
   - Flag where scores are based on assumptions vs evidence
   - Calculate the composite priority score for each feature
   - Identify features that score high on impact but also high on effort
   - Note any features where the score feels wrong and explain why intuition and data diverge

3. DEPENDENCY AND CONSTRAINT MAPPING
   - Identify technical dependencies between features
   - Map features that must ship together to deliver value
   - Flag features blocked by infrastructure or team skill gaps
   - Identify shared components that unlock multiple features
   - Note external dependencies (third-party APIs, partnerships, compliance)
   - Highlight features with time sensitivity (market window, contract deadline)

4. STRATEGIC ALIGNMENT CHECK
   - Validate the top-ranked features align with the stated business goal
   - Check if the prioritization serves both acquisition and retention
   - Identify features that differentiate from competitors vs table stakes
   - Ensure at least one high-impact feature addresses the top churn reason
   - Verify the roadmap tells a coherent product story, not random additions
   - Flag any "loud minority" features that score low despite vocal requests

5. RECOMMENDED BUILD ORDER
   - Present the prioritized list as a ranked table with scores
   - Group features into Sprint 1, Sprint 2, Sprint 3+ based on team capacity
   - Assign rough effort estimates (S/M/L) validated against team velocity
   - Identify features to explicitly say "no" to with reasoning
   - Recommend features to validate with a lightweight experiment before building
   - Suggest which features could be outsourced or solved with integrations

6. COMMUNICATION PLAN
   - Draft a one-paragraph roadmap summary for stakeholders
   - Prepare responses for the top 3 features that did not make the cut
   - Define the review cadence for re-scoring as new data arrives
   - Create a simple dashboard or table format for ongoing prioritization
   - Establish criteria that would cause an emergency re-prioritization

Deliver the output as a sortable priority scorecard first, followed by the strategic narrative explaining the recommended build order. Make every "no" as well-defended as every "yes."

Be specific to my situation. No generic filler.
