---
name: deployment-checklist
description: Pre-deployment checklist covering security, performance, monitoring, rollback. Use when launching products, deploying to production, preparing releases, or doing go-live checks.
metadata:
  category: product-building
  author: skillar
  version: "1.0"
---

# Deployment Checklist

*Because every item on this list exists because someone skipped it and got paged at 3 AM.*

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A comprehensive pre-deployment checklist customized to your stack and deployment target, covering security hardening, performance validation, monitoring setup, and rollback procedures.

## Instructions

You are a site reliability engineer who has overseen hundreds of production deployments, including several that went catastrophically wrong. Those failures taught you exactly which checks prevent 3 AM pages. You build checklists that are thorough without being ceremonial — every item exists because skipping it has caused a real incident.

Create a deployment checklist for the following release:

- **Application type:** [APP_TYPE — e.g., web application with REST API and background workers]
- **Tech stack:** [TECH_STACK — e.g., Next.js, Node.js, PostgreSQL, Redis, deployed on AWS]
- **Deployment target:** [DEPLOY_TARGET — e.g., Vercel + AWS ECS + RDS]
- **Deployment method:** [DEPLOY_METHOD — e.g., CI/CD via GitHub Actions, manual, blue-green]
- **Release type:** [RELEASE_TYPE — e.g., first production launch, major feature release, routine update]
- **Database changes:** [DB_CHANGES — e.g., new tables, column migrations, data backfill, none]
- **External dependencies:** [DEPENDENCIES — e.g., Stripe, SendGrid, Twilio, AWS S3]

1. PRE-DEPLOYMENT VALIDATION
   - Verify all CI/CD pipeline checks pass on the release branch
   - Confirm staging environment mirrors production configuration
   - Validate all environment variables are set in production
   - Run the full test suite against a staging build
   - Verify database migration runs cleanly on a staging copy
   - Confirm all third-party API keys are production keys, not test keys

2. SECURITY HARDENING
   - Verify HTTPS is enforced with valid SSL certificates
   - Confirm security headers are set (HSTS, CSP, X-Frame-Options)
   - Validate CORS configuration allows only expected origins
   - Ensure all API endpoints require authentication where expected
   - Check that sensitive data is encrypted at rest and in transit
   - Verify no secrets are exposed in client-side code or source maps
   - Confirm rate limiting is active on auth and public endpoints

3. PERFORMANCE VALIDATION
   - Run load test simulating expected peak traffic
   - Verify response times are within acceptable thresholds
   - Check database query performance on production-scale data
   - Confirm CDN is configured for static assets
   - Validate image optimization and compression settings
   - Verify caching headers are set correctly for each content type

4. MONITORING AND ALERTING
   - Confirm error tracking service is configured and receiving events
   - Set up uptime monitoring for all critical endpoints
   - Configure alerting thresholds for error rate spikes
   - Verify application logs are flowing to centralized logging
   - Set up performance monitoring for response times and throughput
   - Create dashboard with key metrics visible to the team
   - Test that alerts actually reach the on-call channel

5. DATABASE AND DATA
   - Back up the production database before deployment
   - Verify migration scripts have been tested on production-size data
   - Confirm migrations are backwards-compatible with current application code
   - Plan migration execution order relative to application deployment
   - Verify data backfill scripts are idempotent and resumable
   - Confirm connection pool settings are appropriate for production load

6. ROLLBACK PLAN
   - Document the exact steps to rollback the application deployment
   - Verify database migrations have corresponding rollback scripts
   - Test the rollback procedure on staging before deploying
   - Define the metrics that trigger an automatic or manual rollback
   - Ensure previous application version is tagged and deployable
   - Assign a rollback decision-maker and communication plan
   - Verify rollback can be completed within the acceptable downtime window

7. POST-DEPLOYMENT VERIFICATION
   - Run smoke tests against production immediately after deployment
   - Verify critical user flows work end-to-end in production
   - Check error rates for the first 15, 30, and 60 minutes
   - Monitor database performance for unexpected query patterns
   - Verify background jobs and scheduled tasks are running
   - Confirm email, payment, and third-party integrations work in production
   - Send deployment notification to the team with release notes

Format as a printable checklist with checkboxes, organized by phase (before, during, after deployment). Include time estimates for each section so the team can plan the deployment window.

Be specific to my situation. No generic filler.
