---
name: code-review-checklist
description: Creates comprehensive code review checklist customized to your stack. Use when establishing review standards, onboarding reviewers, improving code quality, or creating PR templates.
metadata:
  category: product-building
  author: skillar
  version: "1.0"
---

# Code Review Checklist

*Because nitpicking style kills velocity. Focus reviews on what matters.*

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A detailed, stack-specific code review checklist that your team can use as a PR template or reviewer guide, covering correctness, security, performance, and maintainability.

## Instructions

You are a staff engineer who has reviewed thousands of pull requests across multiple tech stacks. You catch the bugs that slip past tests, spot the performance issues that only appear at scale, and flag the security holes that junior devs miss. You also know that nitpicking style kills team velocity, so you focus reviews on what matters.

Create a code review checklist for the following project:

- **Tech stack:** [TECH_STACK — e.g., React + TypeScript frontend, Python FastAPI backend, PostgreSQL]
- **Project type:** [PROJECT_TYPE — e.g., fintech SaaS, e-commerce platform, developer tool]
- **Team size and seniority:** [TEAM — e.g., 4 devs, mix of junior and mid-level]
- **Common PR types:** [PR_TYPES — e.g., feature work, bug fixes, API endpoints, UI components]
- **Existing tooling:** [TOOLING — e.g., ESLint, Prettier, Jest, no CI yet]
- **Known pain points:** [PAIN_POINTS — e.g., inconsistent error handling, no tests, slow queries]

1. CORRECTNESS AND LOGIC
   - Verify the code actually solves the stated problem
   - Check edge cases: empty arrays, null values, zero, negative numbers
   - Validate error paths are handled, not just happy paths
   - Ensure state mutations are intentional and side-effect-free where expected
   - Confirm database transactions wrap related operations atomically
   - Check for off-by-one errors in loops and pagination

2. SECURITY REVIEW
   - Verify user input is validated and sanitized at the boundary
   - Check SQL queries use parameterized statements, never string concatenation
   - Ensure authentication checks are present on all protected endpoints
   - Verify authorization confirms the user owns the requested resource
   - Check for sensitive data exposure in logs, error messages, or responses
   - Confirm secrets are not hardcoded and environment variables are used

3. PERFORMANCE CHECKS
   - Identify N+1 query patterns in database access code
   - Check for missing database indexes on new query patterns
   - Verify pagination is implemented for list endpoints
   - Look for unnecessary re-renders in frontend components
   - Check that large file uploads use streaming, not memory buffering
   - Confirm expensive operations are async or queued appropriately

4. READABILITY AND MAINTAINABILITY
   - Verify naming is clear and consistent with codebase conventions
   - Check that functions do one thing and are under 40 lines
   - Ensure complex logic has explanatory comments for the "why"
   - Verify no dead code, commented-out blocks, or console.logs remain
   - Confirm types and interfaces are defined, not using "any"
   - Check that magic numbers are replaced with named constants

5. TESTING COVERAGE
   - Verify new logic has corresponding unit tests
   - Check that edge cases identified above have test coverage
   - Ensure mocks are minimal and test real behavior where possible
   - Verify integration tests exist for new API endpoints
   - Confirm tests are deterministic and not dependent on execution order
   - Check that test descriptions clearly state the expected behavior

6. INFRASTRUCTURE AND DEPLOYMENT
   - Verify database migrations are reversible
   - Check that new environment variables are documented
   - Confirm feature flags gate incomplete features
   - Verify backwards compatibility if the change affects APIs
   - Check that monitoring and alerting cover new failure modes

Format the checklist as a markdown document with checkboxes that can be pasted directly into a PR template. Include a severity rating (blocker, major, minor) for each item so reviewers know which issues must block merge vs which are nice-to-fix.

Be specific to my situation. No generic filler.
