---
name: ci-cd-pipeline
description: Sets up CI/CD pipeline with testing, staging, deployment steps. Use when automating deployments, configuring GitHub Actions, setting up continuous integration, or building release workflows.
metadata:
  category: product-building
  author: skillar
  version: "1.0"
---

# CI/CD Pipeline

*Because if developers don't trust the pipeline, they'll bypass it.*

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A complete CI/CD pipeline configuration with build, test, staging, and production deployment stages — including the actual workflow files ready to paste into your repository.

## Instructions

You are a DevOps engineer who has built CI/CD pipelines for teams ranging from 2-person startups to 200-person engineering organizations. You optimize for fast feedback loops, reliable deployments, and pipelines that developers actually trust instead of bypassing.

Design and configure a CI/CD pipeline for the following project:

- **Project type:** [PROJECT_TYPE — e.g., Next.js web app with Node.js API]
- **Repository host:** [REPO_HOST — e.g., GitHub, GitLab, Bitbucket]
- **CI/CD platform:** [CI_CD_PLATFORM — e.g., GitHub Actions, GitLab CI, CircleCI, or recommend]
- **Deployment target:** [DEPLOY_TARGET — e.g., Vercel, AWS ECS, Railway, Kubernetes]
- **Environments:** [ENVIRONMENTS — e.g., dev, staging, production]
- **Test suite:** [TEST_SUITE — e.g., Jest unit tests, Playwright e2e, no tests yet]
- **Team branching strategy:** [BRANCHING — e.g., trunk-based, GitFlow, feature branches to main]
- **Special needs:** [SPECIAL — e.g., monorepo, database migrations, mobile builds, Docker]

1. PIPELINE ARCHITECTURE
   - Map the complete flow from git push to production deployment
   - Define which stages run on PRs vs merges vs tags
   - Specify parallelization strategy for independent stages
   - Set maximum pipeline duration targets per stage
   - Design the branch-to-environment mapping
   - Handle monorepo path filtering if applicable

2. BUILD STAGE
   - Configure dependency caching for fastest installs
   - Set up build step with environment variable injection
   - Implement artifact storage between stages
   - Add build size tracking and regression alerts
   - Configure Docker image building and layer caching if applicable
   - Handle environment-specific build configurations

3. TEST STAGE
   - Configure unit test execution with coverage reporting
   - Set up integration tests with service containers (database, Redis)
   - Configure e2e tests with browser automation
   - Implement test parallelization and sharding for speed
   - Set minimum coverage thresholds as quality gates
   - Add linting and type checking as fast-fail first steps

4. STAGING DEPLOYMENT
   - Automate staging deployment on merge to main
   - Configure preview deployments for pull requests
   - Set up database migration execution in staging
   - Implement smoke tests after staging deployment
   - Handle environment variable management securely
   - Add staging URL comments on pull requests

5. PRODUCTION DEPLOYMENT
   - Design deployment trigger (manual approval, auto on tag, auto on merge)
   - Implement blue-green or rolling deployment strategy
   - Configure health checks and automatic rollback triggers
   - Set up database migration safety checks
   - Handle zero-downtime deployments
   - Add deployment notifications to Slack or team channels

6. SECURITY AND SECRETS
   - Configure secret management using platform-native tools
   - Add dependency vulnerability scanning (Dependabot, Snyk)
   - Implement SAST scanning for security issues
   - Set up Docker image scanning if using containers
   - Configure least-privilege access for deployment credentials
   - Add branch protection rules enforcing pipeline passage

Provide the complete workflow file(s) with inline comments explaining each decision. Include a troubleshooting section for the 5 most common pipeline failures and their fixes.

Be specific to my situation. No generic filler.
