---
name: auth-system-design
description: Designs authentication and authorization system with JWT, OAuth, sessions, RBAC. Use when building login systems, setting up user permissions, implementing SSO, or securing APIs.
metadata:
  category: product-building
  author: skillar
  version: "1.0"
---

# Auth System Design

*Because a single auth vulnerability means game over.*

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A complete authentication and authorization system design covering signup flows, token management, role-based access, and security hardening — ready to implement or hand to your team.

## Instructions

You are a security-focused backend engineer who has built auth systems for fintech and healthcare products where a single vulnerability means catastrophic breach. You balance security rigor with developer experience, knowing that overly complex auth leads to workarounds that are worse than simpler designs.

Design an auth system for the following product:

- **Product type:** [PRODUCT_TYPE — e.g., multi-tenant B2B SaaS with team workspaces]
- **User types:** [USER_TYPES — e.g., admin, team member, guest, API consumer]
- **Auth requirements:** [AUTH_REQUIREMENTS — e.g., email/password, Google OAuth, magic links, SSO]
- **Authorization model:** [AUTHZ_MODEL — e.g., RBAC with workspace-level permissions]
- **Tech stack:** [TECH_STACK — e.g., Next.js frontend, Node.js backend, PostgreSQL]
- **Compliance needs:** [COMPLIANCE — e.g., SOC2, GDPR, HIPAA, or none yet]
- **Special requirements:** [SPECIAL — e.g., impersonation for support, API keys, MFA]

1. AUTHENTICATION FLOWS
   - Design email/password signup with email verification steps
   - Map OAuth/social login flow with account linking strategy
   - Define magic link or passwordless flow if applicable
   - Specify password requirements, hashing algorithm (bcrypt/argon2), and salt strategy
   - Handle account recovery and password reset securely
   - Design MFA enrollment and verification flow

2. TOKEN ARCHITECTURE
   - Choose token strategy (JWT, opaque, session) with security justification
   - Define access token payload, expiration, and signing algorithm
   - Design refresh token rotation with reuse detection
   - Specify token storage on client (httpOnly cookie vs memory vs localStorage)
   - Handle token revocation for logout and security events
   - Address token validation on each request with minimal database hits

3. AUTHORIZATION MODEL
   - Define roles with specific permissions for each user type
   - Design permission checking middleware with deny-by-default
   - Handle resource-level authorization (user can only edit own records)
   - Implement organization/workspace scoping for multi-tenancy
   - Design permission inheritance and override rules
   - Create a permissions matrix table for all roles and resources

4. SESSION MANAGEMENT
   - Define session lifecycle (creation, refresh, expiration, termination)
   - Handle concurrent sessions across devices
   - Implement session listing and remote logout capability
   - Design session fixation and hijacking prevention
   - Specify idle timeout vs absolute timeout policies

5. SECURITY HARDENING
   - Implement brute force protection with progressive delays
   - Design account lockout and unlock procedures
   - Add suspicious activity detection (new device, new location)
   - Specify CSRF protection strategy
   - Handle secure cookie configuration (Secure, SameSite, HttpOnly)
   - Plan for credential stuffing and bot detection

6. API KEY MANAGEMENT
   - Design API key generation with appropriate entropy
   - Implement key scoping with granular permissions
   - Handle key rotation without downtime
   - Build key usage tracking and rate limiting
   - Create key revocation and expiration policies

Deliver the design as a flow diagram description for each auth scenario, followed by the data model for auth-related tables, and implementation pseudocode for the critical middleware. Highlight the top 5 security mistakes to avoid during implementation.

Be specific to my situation. No generic filler.
