---
name: api-documentation
description: Generates API documentation with examples, error codes, and authentication guide. Use when documenting endpoints, creating API references, writing developer guides, or building API portals.
metadata:
  category: product-building
  author: skillar
  version: "1.0"
---

# API Documentation

*Because great docs reduce support tickets by 80%.*

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
Production-ready API documentation with endpoint references, request/response examples, authentication guide, error code catalog, and quickstart tutorial that developers can use without asking questions.

## Instructions

You are a developer experience engineer who has written API documentation used by thousands of developers. You know that great API docs reduce support tickets by 80%. You write docs that a developer can follow at 11 PM on a deadline, with clear examples, zero ambiguity, and copy-pasteable code.

Generate API documentation for the following API:

- **API name:** [API_NAME — e.g., Acme Platform API]
- **API style:** [API_STYLE — e.g., REST, GraphQL]
- **Base URL:** [BASE_URL — e.g., https://api.acme.com/v1]
- **Authentication method:** [AUTH — e.g., Bearer token via JWT, API key in header]
- **Core resources:** [RESOURCES — e.g., users, projects, tasks, comments, webhooks]
- **Audience:** [AUDIENCE — e.g., third-party developers building integrations, internal frontend team]
- **Endpoint list (if available):** [ENDPOINTS — e.g., POST /auth/login, GET /projects, POST /projects/:id/tasks, etc.]

1. QUICKSTART GUIDE
   - Write a 5-minute getting started tutorial from signup to first API call
   - Include authentication setup with step-by-step instructions
   - Provide a curl example that returns real data on first try
   - Show the same example in JavaScript, Python, and one other popular language
   - Link to SDKs or client libraries if available
   - Include a "test your setup" verification step

2. AUTHENTICATION REFERENCE
   - Document every authentication method supported
   - Explain token lifecycle: obtaining, using, refreshing, revoking
   - Provide authentication header format with exact syntax
   - Document token expiration handling and refresh flow
   - Show error responses for invalid, expired, and missing tokens
   - Include security best practices for token storage

3. ENDPOINT REFERENCE
   - Document each endpoint with: method, path, description, auth requirement
   - List all path parameters, query parameters, and request body fields
   - Specify data types, required/optional status, default values, and constraints
   - Provide request example with all parameters populated
   - Show success response with full JSON body and status code
   - Document each possible error response with status code and message
   - Include pagination parameters and response format for list endpoints

4. ERROR CODE CATALOG
   - Create a complete table of all error codes with HTTP status and meaning
   - Group errors by category: authentication, validation, resource, server
   - Provide the exact error response JSON format with all fields
   - Include troubleshooting steps for the 10 most common errors
   - Document rate limit error format with retry-after guidance
   - Explain how to distinguish client errors from server errors

5. WEBHOOKS AND EVENTS
   - List all webhook event types with trigger conditions
   - Document the webhook payload format for each event
   - Explain webhook signature verification with code examples
   - Provide retry policy and failure handling documentation
   - Include testing instructions for simulating webhook events
   - Document webhook management endpoints (create, list, delete)

6. ADVANCED TOPICS
   - Document pagination patterns with cursor and offset examples
   - Explain filtering, sorting, and field selection query syntax
   - Document batch and bulk operation endpoints
   - Describe rate limiting tiers, headers, and best practices for staying under limits
   - Provide versioning policy and migration guides between versions
   - Include idempotency key usage for safe retry of mutations

Format the documentation in clean markdown with consistent structure across all endpoints. Every endpoint must include at least one complete curl example with expected response. Use realistic data in examples, not lorem ipsum.

Be specific to my situation. No generic filler.
