---
name: api-architecture
description: Plans RESTful or GraphQL API with endpoints, auth, versioning, rate limiting. Use when designing APIs, planning backend routes, structuring microservices, or building integrations.
metadata:
  category: product-building
  author: skillar
  version: "1.0"
---

# API Architecture

*Because a bad API is technical debt you pay on every single feature after it.*

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A complete API architecture document with endpoint definitions, authentication flows, versioning strategy, rate limiting rules, and error handling conventions ready for implementation.

## Instructions

You are a backend architect who has designed APIs consumed by millions of clients. You build APIs that are intuitive for developers, performant under load, and evolvable without breaking changes. You follow REST best practices but know when to break convention for pragmatism.

Design the API architecture for the following product:

- **Product description:** [PRODUCT_DESCRIPTION — e.g., team collaboration platform with real-time messaging]
- **API style preference:** [API_STYLE — e.g., REST, GraphQL, or recommend based on use case]
- **Core resources:** [CORE_RESOURCES — e.g., users, workspaces, channels, messages, files]
- **Client types:** [CLIENTS — e.g., web SPA, iOS app, third-party integrations]
- **Authentication method:** [AUTH_METHOD — e.g., JWT, API keys, OAuth2, or recommend]
- **Expected traffic:** [TRAFFIC — e.g., 1k RPM at launch, 100k RPM at scale]
- **Special requirements:** [REQUIREMENTS — e.g., webhooks, real-time updates, file uploads, batch operations]

1. API STYLE DECISION
   - Justify REST vs GraphQL vs hybrid based on client needs
   - Define base URL structure and environment conventions
   - Specify content type and serialization format
   - Establish naming conventions (plural nouns, kebab-case, etc.)
   - Define pagination strategy (cursor vs offset) with reasoning

2. RESOURCE ENDPOINTS
   - List every endpoint with HTTP method, path, and one-line description
   - Group endpoints by resource with consistent CRUD patterns
   - Define nested resource routes and when to use them vs filters
   - Specify request body schemas for POST/PUT/PATCH operations
   - Document query parameters for filtering, sorting, and field selection
   - Include bulk operation endpoints where appropriate

3. AUTHENTICATION AND AUTHORIZATION
   - Design the complete auth flow (signup, login, refresh, logout)
   - Specify token format, expiration, and refresh strategy
   - Define authorization model (RBAC, ABAC, resource-based)
   - List permission levels and which endpoints each can access
   - Design API key management for third-party integrations
   - Handle multi-tenancy isolation at the API layer

4. ERROR HANDLING AND RESPONSES
   - Define standard response envelope format
   - Create error code taxonomy with HTTP status mapping
   - Design validation error format with field-level detail
   - Specify rate limit headers and 429 response format
   - Document idempotency key handling for mutation endpoints

5. VERSIONING AND EVOLUTION
   - Choose versioning strategy (URL path, header, query param) with justification
   - Define deprecation policy and sunset header usage
   - Plan for non-breaking changes vs breaking changes
   - Establish changelog and migration guide conventions
   - Design feature flags for gradual API rollouts

6. RATE LIMITING AND SECURITY
   - Define rate limit tiers per authentication level
   - Specify rate limit windows and burst allowances
   - Design throttling strategy for expensive operations
   - List required security headers (CORS, CSP, HSTS)
   - Address input validation and SQL injection prevention
   - Plan for DDoS mitigation at the API gateway level

Deliver the architecture as an endpoint reference table first, followed by detailed specifications for each cross-cutting concern. Include curl examples for the 5 most important endpoints.

Be specific to my situation. No generic filler.
