---
name: why-now-narrative
description: Builds the market timing argument for why your idea is inevitable right now. Use when market timing, why now, pitch narrative, launch story, investor pitch.
metadata:
  category: idea-validation
  author: skillar
  version: "1.0"
---

# "Why Now?" Narrative

*Because timing is the number one predictor of startup success.*

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A compelling market timing narrative identifying macro trends, enabling conditions, and urgency triggers, plus a ready-to-use "Why Now" paragraph for pitch decks, ProductHunt launches, and investor emails.

## Instructions

You are a narrative strategist who helps founders articulate why their idea is inevitable right now. You know that timing is the number one predictor of startup success, and the best founders can explain exactly why this moment matters.

My product: [PRODUCT DESCRIPTION]
Industry: [INDUSTRY OR MARKET]
Target customer: [WHO THIS IS FOR]

Build a compelling "Why Now?" narrative:

1. MARKET SHIFTS
   - Identify 3 macro trends from the last 2-3 years that make this idea more viable now than ever before
   - Cover technology shifts, behavior changes, and regulatory or economic changes
   - For each trend, cite specific data points or events that prove the shift is real
   - Explain how each trend directly creates demand for my specific product

2. ENABLING CONDITIONS
   - What infrastructure, platforms, APIs, or tools exist now that did not exist 3 years ago?
   - How do these new capabilities make building and distributing my product dramatically easier or cheaper?
   - What has changed about customer expectations or willingness to adopt new tools?
   - Name the specific technologies or platforms that make this possible today

3. TIPPING POINT
   - Identify the specific moment, event, or inflection point that creates urgency for this solution right now
   - Explain why a founder building this 2 years ago would have been too early
   - Explain why a founder starting 2 years from now would be too late
   - What is the window of opportunity and how long does it stay open?

4. COST OF WAITING
   - What happens to a customer who waits 12 months to solve this problem?
   - Quantify the financial, competitive, or opportunity cost of inaction
   - Frame the cost in terms that resonate with my specific target customer
   - Make the urgency feel personal and immediate

5. "WHY NOW" PARAGRAPH
   - Write a 3-sentence paragraph I can use directly in my pitch deck
   - Write a version optimized for a ProductHunt first comment
   - Write a version optimized for an investor cold email opener
   - Each version must be self-contained and immediately compelling

Be specific to my industry and product. Generic trend references like "AI is growing" are not acceptable without tying them directly to my product's opportunity.

Be specific to my situation. No generic filler.
