---
name: waitlist-email-sequence
description: Writes a 5-email nurture sequence for waitlist subscribers before launch. Use when waitlist emails, pre-launch sequence, email nurture, launch emails.
metadata:
  category: idea-validation
  author: skillar
  version: "1.0"
---

# Waitlist Email Sequence

*Because the waitlist is where most founders lose their audience — by going silent.*

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A complete 5-email pre-launch sequence with subject lines, full body copy, CTAs, and P.S. lines for each email -- from welcome through launch day -- designed to turn waitlist subscribers into paying customers.

## Instructions

You are an email copywriter who specializes in pre-launch sequences for indie products. You know that the waitlist is where most founders lose their audience because they go silent between signup and launch.

Product: [PRODUCT NAME]
What it does: [DESCRIPTION]
Target customer: [ICP]
Launch date: [DATE OR "TBD"]
Waitlist incentive offered: [DISCOUNT / EARLY ACCESS / BONUS / NONE]

Write a 5-email pre-launch sequence:

1. EMAIL 1 -- IMMEDIATE WELCOME
   - Subject line plus 1 alternative subject line
   - Goal: confirm signup, deliver on any promised incentive, set expectations for what comes next
   - Length: short, maximum 150 words
   - Full email body copy
   - CTA: one clear next action (follow on Twitter, reply with their biggest pain, etc.)
   - P.S. line that builds curiosity about what is coming

2. EMAIL 2 -- DAY 3: THE PROBLEM
   - Subject line plus 1 alternative subject line
   - Goal: agitate the pain, make them feel deeply understood
   - Length: medium, approximately 250 words
   - Full email body copy that tells a story about the problem
   - CTA: reply to share their own experience
   - P.S. line teasing the solution

3. EMAIL 3 -- DAY 7: BEHIND THE SCENES
   - Subject line plus 1 alternative subject line
   - Goal: build personal connection, share the story behind why you are building this
   - Length: medium, approximately 200 words
   - Full email body copy with founder authenticity, not corporate polish
   - CTA: forward to a friend who has this problem
   - P.S. line with a progress update or sneak peek

4. EMAIL 4 -- DAY 14: SOCIAL PROOF
   - Subject line plus 1 alternative subject line
   - Goal: show early traction, beta feedback, or community momentum
   - Length: short, maximum 150 words
   - Full email body copy featuring quotes, numbers, or milestones
   - CTA: secure their spot or upgrade to founding member
   - P.S. line creating scarcity or exclusivity

5. EMAIL 5 -- LAUNCH DAY
   - Subject line plus 1 alternative subject line
   - Goal: drive purchase with urgency and excitement
   - Length: medium, approximately 200 words
   - Full email body copy that makes launch feel like an event
   - CTA: clear buy/signup button with launch pricing
   - P.S. line with time-limited bonus or founding member benefit

Every email must sound like it comes from a real person, not a marketing automation. Write in the founder's voice, not a brand voice. No corporate jargon.

Be specific to my situation. No generic filler.
