---
name: reddit-validation
description: Generates a Reddit research plan to validate demand without building anything. Use when Reddit research, community validation, demand testing, quick validation.
metadata:
  category: idea-validation
  author: skillar
  version: "1.0"
---

# Reddit Validation Research

*Because Reddit will tell you the truth your friends won't.*

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A complete Reddit validation research plan with target subreddits, search queries, signal scoring criteria, a community post template, and a DM template for booking validation calls -- all executable in under one hour.

## Instructions

You are a growth researcher who uses Reddit as a primary validation tool for early-stage startups.

My product idea: [PRODUCT IDEA]
Problem it solves: [PROBLEM]
Target audience: [AUDIENCE]

Create a Reddit validation research plan I can execute today:

1. TARGET SUBREDDITS
   - List 10 most relevant subreddits where my target customer is active
   - For each subreddit include the name, subscriber count estimate, why this audience is relevant to my product, and estimated percentage of my ICP in this community
   - Rank from highest to lowest relevance
   - Note each subreddit's rules around self-promotion and product discussion

2. SEARCH QUERIES
   - Write 20 specific search queries I can run on Reddit to find people complaining about [PROBLEM]
   - Include queries to find people asking for solutions like mine
   - Include queries to surface existing workarounds people have built
   - Include queries to discover how much people have paid for alternatives
   - Format as exact copy-paste strings for the Reddit search bar

3. SIGNAL SCORING
   - Define what constitutes a strong signal (proceed to build)
   - Define what constitutes a medium signal (needs more validation)
   - Define what constitutes a weak signal (pivot or kill the idea)
   - Include specific numbers: post upvotes, comment counts, recency thresholds

4. POST TEMPLATE
   - Write a post I can publish to get direct feedback on my idea
   - Must be genuine, not salesy, and appropriate for the community
   - Include a hook that invites discussion rather than promotion
   - Suggest which subreddit to post in first and when to post for maximum visibility

5. DM TEMPLATE
   - Write a direct message to send to people who posted about this problem
   - Goal: book a 15-minute validation call
   - Must not feel like spam or a sales pitch
   - Include a reason why you are reaching out that feels personal and specific

Be practical. Every element should be something I can act on within the next 60 minutes.

Be specific to my situation. No generic filler.
