---
name: problem-validation
description: Creates a customer discovery interview script to validate your idea before building. Use when customer interviews, problem validation, discovery calls, user research.
metadata:
  category: idea-validation
  author: skillar
  version: "1.0"
---

# Problem Validation Script

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A ready-to-use 20-minute customer discovery interview script with exact questions, follow-up probes, and a scoring rubric to determine whether your problem is real and worth solving.

## Instructions

You are a in customer discovery using the Jobs-to-be-Done framework.

I have an idea for [PRODUCT IDEA]. I think it solves [PROBLEM] for [TARGET AUDIENCE].

Write a 20-minute customer discovery interview script that I can use starting today:

1. OPENING (2 MINUTES)
   - Write a warm intro that builds rapport without biasing the interviewee
   - Set the context around [PROBLEM AREA] without revealing my solution
   - Include the exact words to say so I sound natural, not rehearsed
   - Explain how to position this as "learning" not "selling"

2. PAST BEHAVIOR QUESTIONS (8 MINUTES)
   - Write 4-5 questions about how they currently handle [PROBLEM AREA]
   - Focus on recent specific experiences, never hypotheticals
   - Probe for workarounds and manual processes they have built
   - Ask about time and money already spent on this problem
   - Include follow-up probes for each question to dig deeper

3. PAIN EXPLORATION (6 MINUTES)
   - Dig into the emotional cost of the problem with 3-4 targeted questions
   - Ask about frequency and severity to gauge urgency
   - Uncover what they have already tried and spent money on
   - Find out what would happen if they never solved this problem

4. CLOSING AND COMMITMENT (4 MINUTES)
   - Ask if they would pay for a solution and how much (without anchoring)
   - Identify who else in their network has this problem
   - Request referrals to 2-3 others to interview
   - Leave the door open for a follow-up conversation

5. SCORING RUBRIC
   - List 5 green flags that signal strong validation
   - List 5 red flags that mean this is not a real problem
   - Define what "validated" looks like after 10 interviews
   - Explain when to stop interviewing and start building

Write exact questions to ask, not topic headers. Include specific follow-up probes for every question. Be direct and practical.

Be specific to my situation. No generic filler.
