---
name: pricing-experiment
description: Designs a pricing test to find your optimal price point before launch. Use when pricing strategy, willingness to pay, price testing, monetization.
metadata:
  category: idea-validation
  author: skillar
  version: "1.0"
---

# Pricing Experiment Design

*Because your first price is always wrong. The question is how fast you fix it.*

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A complete pricing experiment you can run in two weeks, including three price hypotheses, test methodology, pricing page copy for each tier, success benchmarks, and a final pricing model recommendation.

## Instructions

You are a pricing strategist who has helped 50+ SaaS companies optimize revenue.

My product: [PRODUCT DESCRIPTION]
Target customer: [TARGET AUDIENCE]
Current pricing idea: [YOUR PRICE IDEA]
Competitors charge: [COMPETITOR PRICES]

Design a pricing experiment I can run in the next 2 weeks:

1. PRICING HYPOTHESES
   - Generate 3 pricing hypotheses to test against each other
   - Hypothesis A: Lower price point with rationale for why it might win
   - Hypothesis B: Your current idea with rationale for keeping it
   - Hypothesis C: Higher price point with rationale for premium positioning
   - For each, explain the customer psychology behind the number

2. TEST METHODOLOGY
   - How to test each price without a live product
   - Landing page setup with "Buy Now" button (no actual charge)
   - Fake door test configuration and tracking setup
   - Customer interview approach for direct willingness-to-pay signals
   - Tools to use and estimated cost of running the test

3. PRICING PAGE COPY
   - For each price point, write a headline that justifies the price
   - Include 5 bullet points of value that anchor the price
   - Write a risk reversal statement (guarantee or trial)
   - Add a comparison anchor ("Less than the cost of...")

4. SUCCESS METRICS
   - Click-through rate benchmarks that indicate validated demand
   - Email capture rate that signals strong willingness to pay
   - Conversation signals from interviews that confirm the right price
   - When to stop testing and commit to a price

5. FINAL RECOMMENDATION
   - Based on [TARGET AUDIENCE] and [COMPETITOR PRICES], recommend a pricing model
   - Evaluate: one-time, subscription, usage-based, and freemium options
   - Explain which model fits my product type and customer expectations
   - Suggest launch price versus long-term price strategy

Be specific to my product category. No theoretical pricing frameworks without practical application.

Be specific to my situation. No generic filler.
