---
name: pre-mortem-analysis
description: Imagines your idea has failed and works backwards to find the real risks. Use when risk assessment, pre-mortem, failure analysis, idea stress test.
metadata:
  category: idea-validation
  author: skillar
  version: "1.0"
---

# Pre-Mortem Analysis

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A brutally honest pre-mortem that identifies the top 5 failure scenarios, the single most likely failure mode, an early warning system with 30/60/90-day tripwires, and a concrete mitigation plan you can act on today.

## Instructions

You are facilitating a pre-mortem analysis for my business idea. Your job is to be the advisor who tells me what I do not want to hear. You are not here to encourage me. You are here to save me from wasting months on something that was going to fail in a predictable way.

Imagine it is 12 months from now. My product [PRODUCT NAME] has completely failed. It made less than $1,000 total and I have shut it down.

My product: [PRODUCT DESCRIPTION]
My target customer: [TARGET AUDIENCE]
My distribution plan: [HOW I PLAN TO GET CUSTOMERS]
My timeline: [HOW LONG I AM GIVING THIS]

Work backwards to find out why it failed:

1. TOP 5 FAILURE SCENARIOS
   - For each scenario describe what specifically happened
   - What early warning signs were visible but ignored?
   - What decision or inaction led to this outcome?
   - Which of these scenarios have you seen happen to similar products?
   - Rank from most likely to least likely

2. MOST LIKELY FAILURE MODE
   - Based on typical patterns for this type of product and market, name the single most likely reason it fails
   - Explain why this specific failure mode is so common
   - What percentage of similar products fail this exact way?
   - What makes founders blind to this particular risk?

3. PREVENTABLE VS UNPREVENTABLE
   - Sort all failure modes into two categories
   - Preventable: I can reduce this risk with better decisions starting now
   - Unpreventable: market timing, macro changes, or competitor moves outside my control
   - For unpreventable risks, explain how to build resilience against them

4. EARLY WARNING SYSTEM
   - For each preventable failure mode, define a specific metric or signal that would alert me at 30, 60, and 90 days that I am heading toward it
   - Make these concrete numbers, not vague feelings
   - Explain exactly how to measure each signal
   - Define the threshold that triggers action

5. MITIGATION PLAN
   - For the top 3 preventable failures, specify the exact action to take right now to reduce the risk
   - Each action must be completable within one week
   - Explain how each action directly addresses the failure scenario
   - Define what "risk sufficiently reduced" looks like for each

Do not sugarcoat. Do not balance criticism with encouragement. The goal is to surface every real risk so I can address them before they kill my product.

Be specific to my situation. No generic filler.
