---
name: one-line-pitch
description: Creates multiple versions of your elevator pitch for different contexts. Use when elevator pitch, tagline, positioning copy, product description, Twitter bio.
metadata:
  category: idea-validation
  author: skillar
  version: "1.0"
---

# One-Line Pitch Generator

*Because if you can't explain it in one sentence, you can't sell it in any.*

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
Pitch copy tailored for 6 different contexts -- Twitter bio, ProductHunt tagline, Hacker News, cold email, VC intro, and casual explanation -- each with a primary version, alternative version, and explanation of why it works.

## Instructions

You are a messaging strategist who specializes in startup positioning. You know that the right one-liner can be the difference between someone clicking or scrolling past.

My product: [PRODUCT NAME]
What it does: [FULL DESCRIPTION IN 2-3 SENTENCES]
Who it's for: [TARGET CUSTOMER]
Main outcome: [WHAT THE CUSTOMER ACHIEVES WITH THIS PRODUCT]
Key differentiator: [WHAT MAKES IT DIFFERENT FROM ALTERNATIVES]

Generate positioning copy for 6 contexts:

1. TWITTER BIO (160 CHARACTERS MAX)
   - Punchy, personality-forward, and memorable
   - Must communicate what you build and who it helps
   - Avoid buzzwords, jargon, and empty superlatives
   - Primary version plus one alternative

2. PRODUCT HUNT TAGLINE (60 CHARACTERS MAX)
   - Outcome-focused and immediately clear
   - No buzzwords or vague language
   - Must make sense to someone who has never heard of you
   - Primary version plus one alternative

3. HACKER NEWS SHOW HN (ONE LINE)
   - Technical, specific, and hype-free
   - Lead with what the product does, not why it matters
   - Include the core technology or approach if relevant
   - Primary version plus one alternative

4. COLD EMAIL OPENER (1 SENTENCE)
   - Problem-first framing relevant to the recipient
   - Must earn the next sentence, not close the sale
   - Personalization hook that shows you understand their world
   - Primary version plus one alternative

5. VC INTRO (25 WORDS MAX)
   - Market size plus solution plus traction hint
   - Must sound like a business, not a side project
   - Communicate momentum even if early stage
   - Primary version plus one alternative

6. FRIEND EXPLANATION
   - Simple analogy format: "It's like X but for Y"
   - Must make sense to someone outside the industry
   - Should trigger an immediate "oh, I get it" reaction
   - Primary version plus one alternative

For each context, explain in one sentence why that version works for that specific audience. No generic copy. Every word must earn its place.

Be specific to my situation. No generic filler.
