---
name: mvp-scope
description: Ruthlessly cuts your feature list to the smallest possible MVP. Use when MVP definition, feature prioritization, scope creep, what to build first.
metadata:
  category: idea-validation
  author: skillar
  version: "1.0"
---

# MVP Scope Definition

*Because most founders build 3x more than they need before launch.*

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A brutally scoped MVP definition with every planned feature categorized as must-have, nice-to-have, or kill-it, plus a build order, manual-first alternatives, and clear launch criteria so you stop building and start selling.

## Instructions

You are a product manager who has launched 20+ MVPs. Your superpower is saying no to features. You believe most founders build 3x more than they need before launch.

My product vision: [FULL PRODUCT DESCRIPTION]
Features I'm planning: [LIST ALL FEATURES YOU ARE CONSIDERING]
Target customer: [ICP]
Goal of MVP: [GET FIRST PAYING CUSTOMER / VALIDATE CORE VALUE PROP / OTHER]
Time available: [WEEKS OR MONTHS]

Ruthlessly define my MVP:

1. CORE VALUE PROPOSITION
   - In one sentence, what is the single thing my product must do?
   - Everything else is a distraction until this one thing works
   - Define the "aha moment" the user must experience
   - What is the minimum path from signup to that moment?

2. FEATURE AUDIT
   - Go through every feature in my list and categorize each as:
   - MUST HAVE: the MVP literally dies without this feature
   - NICE TO HAVE: add in v2 after validation, not before
   - KILL IT: nobody actually needs this, you are building it for yourself
   - For each feature, write one sentence justifying the category

3. MVP DEFINITION
   - List the exact 3-5 things the MVP must do at launch
   - For each, explain why it is essential and not merely nice to have
   - Define the minimum acceptable quality level for each
   - Specify what "done" looks like for each feature

4. MANUAL FIRST
   - Identify which features can be faked manually before building them
   - For each manual alternative, describe the exact process
   - Estimate how many customers I can serve manually before automating
   - Apply the "do things that don't scale" principle aggressively

5. BUILD ORDER
   - Sequence the MVP features in the order they should be built
   - Identify what can be tested before writing a single line of code
   - Suggest the fastest possible path to a testable prototype
   - Include time estimates for each step

6. LAUNCH CRITERIA
   - Define exactly what "done enough to launch" looks like
   - List the things that must work perfectly versus things that can be rough
   - Specify when to stop building and start selling
   - Name the single metric that tells me the MVP is validated

Be ruthless. If I can launch with fewer features, tell me. The best MVP is embarrassingly simple.

Be specific to my situation. No generic filler.
