---
name: micro-saas-playbook
description: Step-by-step validation plan for a micro-SaaS idea in 2 weeks. Use when micro-SaaS validation, 2-week sprint, validation playbook, SaaS validation.
metadata:
  category: idea-validation
  author: skillar
  version: "1.0"
---

# Micro-SaaS Validation Playbook

*Because most micro-SaaS founders build for months before talking to a single user.*

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A day-by-day, 2-week validation sprint plan with specific research tasks, landing page setup, traffic targets, interview scripts, decision criteria, and a clear go/no-go framework -- all designed to keep total time under 20 hours.

## Instructions

You are an advisor to micro-SaaS founders who have shipped 10+ products. You know that most developers waste months building before validating. Your playbook prevents that.

My micro-SaaS idea: [IDEA DESCRIPTION]
My tech skills: [WHAT YOU CAN BUILD -- LANGUAGES, FRAMEWORKS, PLATFORMS]
Hours per week available: [HOURS]
Budget for validation: [DOLLAR AMOUNT]

Create a 2-week validation sprint:

1. WEEK 1 -- RESEARCH AND OUTREACH (DAYS 1-7)
   - Days 1-2 Research: exact searches to run on Reddit, Twitter, G2, and Capterra
   - What specific signals to look for in each source
   - How to record and organize findings in a simple spreadsheet
   - Days 3-4 Build landing page: minimum copy needed, no-code tools to use, fake door test setup with click tracking
   - Days 5-7 Drive traffic: exactly where to post, what to write for each community, posting schedule and engagement plan
   - Target: 200 unique visitors by end of week 1
   - Specific tools for each step with free tier options

2. WEEK 2 -- CONVERSATIONS AND DECISION (DAYS 8-14)
   - Days 8-10 Customer interviews: how to get 5 interviews booked from landing page signups and Reddit outreach
   - The exact 8 questions to ask in each interview
   - How to score willingness to pay on a 1-5 scale
   - Days 11-12 Analyze data: compile landing page metrics, interview scores, and research signals into a single decision document

3. GO/NO-GO FRAMEWORK
   - Define the specific metrics that mean GO: minimum conversion rate, interview score threshold, and willingness-to-pay signal
   - Define the specific metrics that mean NO-GO: what numbers tell you to walk away
   - Define MAYBE criteria and what additional test to run if results are ambiguous
   - How to make the decision without emotional bias

4. IF GO: 30-DAY BUILD PLAN
   - What to build in the first 30 days based on validation findings
   - MVP feature list derived from interview feedback
   - First paying customer acquisition plan
   - Revenue target for day 30

5. IF NO-GO: LEARNING EXTRACTION
   - How to document what you learned for future ideas
   - What adjacent problems surfaced during research
   - Framework for deciding what to try next
   - How to repurpose the landing page and email list

Keep total time investment under 20 hours across both weeks. Every task must have a specific deliverable and time estimate. No open-ended research spirals.

Be specific to my situation. No generic filler.
