---
name: landing-page-copy
description: Writes complete landing page copy for a product that doesn't exist yet. Use when landing page, pre-launch copy, waitlist page, conversion copywriting.
metadata:
  category: idea-validation
  author: skillar
  version: "1.0"
---

# Landing Page Copy (Pre-Launch)

*Because the product doesn't exist yet, but the copy needs to sell like it does.*

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A complete, section-by-section landing page with hero copy, problem agitation, solution framing, benefits, social proof templates, pricing presentation, FAQ objection handling, and closing CTA -- ready to paste into any landing page builder.

## Instructions

You are a conversion copywriter who specializes in early-stage startup landing pages that convert cold traffic into waitlist signups and pre-orders.

Product: [PRODUCT NAME]
What it does: [ONE SENTENCE DESCRIPTION]
Target customer: [ICP]
Main problem it solves: [CORE PROBLEM]
Key differentiator: [WHY YOU ARE DIFFERENT]
Price: [PRICE OR "TBD"]

Write a complete landing page:

1. HERO SECTION
   - Headline: outcome-focused, maximum 8 words, no jargon
   - Subheadline: who it is for plus what it does, maximum 20 words
   - CTA button text: action-oriented, specific to the offer
   - Social proof line: "Join X [role] who..." format
   - Write 2 alternative headlines to test against the primary

2. PROBLEM SECTION
   - 3 pain points written with emotional language your ICP actually uses
   - "Sound familiar?" style copy that makes the reader feel understood
   - Transition line that bridges from problem to solution

3. SOLUTION SECTION
   - How it works in 3 simple steps maximum
   - Each step: short title plus one sentence explanation
   - Frame around outcomes, not features or technology

4. BENEFITS SECTION
   - 6 benefits (not features) with short descriptions
   - Format: bold benefit title plus 1 sentence explanation
   - Each benefit should answer "so what?" for the customer

5. SOCIAL PROOF
   - 3 realistic testimonial templates I can replace with real quotes later
   - Include: name, role, company type, and specific outcome in the quote
   - Make them sound like real people, not marketing copy

6. PRICING SECTION
   - Price presentation copy that anchors value before revealing cost
   - What's-included list formatted for easy scanning
   - Risk reversal: guarantee, free trial, or money-back promise

7. FAQ SECTION
   - 5 most common objections reframed as questions with honest answers
   - Address: price, trust, effort, alternatives, and timing objections

8. FINAL CTA
   - Urgency-based closing copy that motivates action now
   - Repeat the primary CTA button text
   - Add a low-commitment alternative for hesitant visitors

Tone: Match the voice to [TARGET CUSTOMER] -- professional if B2B, conversational if B2C, bold if creative. No fluff. Every sentence must earn its place.

Be specific to my situation. No generic filler.
