---
name: jobs-to-be-done
description: Applies the JTBD framework to uncover true customer motivations behind your product. Use when jobs to be done, JTBD, customer motivation, product positioning, messaging.
metadata:
  category: idea-validation
  author: skillar
  version: "1.0"
---

# Jobs To Be Done Analysis

*Because people don't buy products — they hire them to solve a problem.*

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A complete JTBD analysis covering functional, emotional, and social jobs, the hire/fire decision, switch triggers, ranked desired outcomes, and rewritten messaging (headline, value prop, CTA) grounded in what customers actually want.

## Instructions

You are a in the Jobs-to-be-Done framework as developed by Bob Moesta and Clayton Christensen. You understand that customers do not buy products -- they hire them to make progress in their lives.

My product: [PRODUCT DESCRIPTION]
Current positioning: [HOW YOU CURRENTLY DESCRIBE YOUR PRODUCT]
Target customer: [ICP]

Apply the JTBD framework:

1. FUNCTIONAL JOB
   - What is the core task the customer is trying to accomplish?
   - State it as: "Help me [verb] [object] [context]"
   - Break it down into the job steps: what they do before, during, and after
   - Identify where in the job chain the most frustration occurs
   - What does "done well" look like from the customer's perspective?

2. EMOTIONAL JOB
   - How does the customer want to feel while doing this job?
   - What negative feelings do they want to avoid?
   - What emotional outcome matters more than the functional one?
   - How does the current solution make them feel (frustrated, anxious, behind)?

3. SOCIAL JOB
   - How does the customer want to be perceived by others?
   - What does using or not using a solution like mine say about them?
   - Who are they trying to impress, keep up with, or differentiate from?
   - What social status does solving this problem confer?

4. THE HIRE/FIRE DECISION
   - What are they "firing" when they "hire" my product?
   - List every alternative they currently use, including manual workarounds and doing nothing
   - Why is each current alternative falling short?
   - What "switching cost" am I asking them to pay?

5. SWITCH TRIGGERS
   - What specific moment or event causes someone to start looking for a solution?
   - List 5 trigger events that create the "I need to fix this now" moment
   - These triggers define when and where to reach them with marketing
   - Which trigger is most common and most actionable?

6. DESIRED OUTCOMES
   - List 10 specific outcomes the customer wants to achieve
   - Rank by importance to customer multiplied by dissatisfaction with current solutions
   - The top-ranked outcomes are your product's most compelling selling points
   - Identify outcomes your competitors ignore

7. MESSAGING IMPLICATIONS
   - Based on the full JTBD analysis, rewrite the hero headline
   - Rewrite the value proposition in one sentence
   - Rewrite the primary CTA to reflect the job, not the product
   - Explain what changed and why the new messaging is stronger

Be specific to my product and customer. Generic JTBD theory is not useful -- I need applied analysis I can act on immediately.

Be specific to my situation. No generic filler.
