---
name: fake-door-test
description: Sets up a complete fake door test to validate willingness to pay before building. Use when fake door test, pre-launch validation, demand testing, willingness to pay.
metadata:
  category: idea-validation
  author: skillar
  version: "1.0"
---

# Fake Door Test Setup

*Because the best way to validate demand is to sell it before you build it.*

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A complete fake door test plan including page structure, traffic strategy to drive 100 targeted visitors in 48 hours, success metrics with benchmarks, two ready-to-send emails, and a learning framework to interpret every possible outcome.

## Instructions

You are a growth hacker specializing in pre-launch validation who has designed 100+ fake door tests for early-stage startups.

My product: [PRODUCT DESCRIPTION]
Hypothetical price: [PRICE]
Target audience: [AUDIENCE]
Traffic source I'll use: [REDDIT / TWITTER / ADS / LINKEDIN / OTHER]

Design a complete fake door test:

1. TEST SETUP
   - Describe the exact landing page structure and what to show above the fold
   - Recommend the best CTA to use: "Pre-order" vs "Join waitlist" vs "Get early access" and why
   - Specify what page visitors see after they click the CTA
   - List the exact tools to use for the page, email capture, and analytics
   - Explain how to set up click tracking and conversion measurement

2. TRAFFIC STRATEGY
   - Step-by-step plan to drive 100 targeted visitors in 48 hours using [TRAFFIC SOURCE]
   - Write the exact posts, threads, or ad copy to publish
   - List specific communities, subreddits, or groups to share in
   - Specify optimal posting times and engagement strategy
   - Include a backup traffic source if the primary underperforms

3. SUCCESS METRICS
   - Define the click-through rate benchmark that means "validated demand"
   - Define the email capture rate that signals "strong willingness to pay"
   - Specify the threshold at which to kill the test early (too low or too high)
   - Explain how to distinguish genuine interest from curiosity clicks

4. EMAIL SEQUENCE
   - Email 1 (immediate): Thank you message that confirms signup and sets clear expectations about timeline
   - Email 2 (launch day): "It's ready" notification with urgency and clear CTA to purchase or onboard
   - Include subject lines, full body copy, and P.S. lines for both emails

5. LEARNING FRAMEWORK
   - High traffic, low clicks: what it means and what to change
   - Low traffic, high clicks: what it means and what to change
   - High clicks, no email signups: what it means and what to change
   - High emails, low opens: what it means and what to change
   - Provide a decision matrix: when to proceed, iterate, or kill the idea

Be specific to my traffic source and audience. No generic advice about "testing things."

Be specific to my situation. No generic filler.
