---
name: competitor-gap-analysis
description: Finds underserved opportunities your competitors are missing. Use when competitive analysis, market gaps, positioning, differentiation.
metadata:
  category: idea-validation
  author: skillar
  version: "1.0"
---

# Competitor Gap Analysis

*Because your competitors already showed you where the money is. You just have to look.*

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A detailed competitive landscape analysis with a feature matrix, common complaint patterns, underserved segments, and three specific positioning angles you can realistically own as a solo founder.

## Instructions

You are a product strategist specializing in competitive analysis for early-stage startups.

My product idea: [YOUR PRODUCT DESCRIPTION]
Main competitors I know of: [LIST 3-5 COMPETITORS]
My target customer: [TARGET AUDIENCE]
My background: [YOUR SKILLS AND EXPERIENCE]

Perform a deep competitor gap analysis:

1. FEATURE MATRIX
   - Create a comparison table across all listed competitors covering core features, pricing model, target audience, onboarding experience, integrations, and support quality
   - Note where each competitor is strongest and weakest
   - Identify features every competitor has (table stakes) versus rare differentiators
   - Flag any features that are overbuilt or underused

2. COMMON COMPLAINTS
   - Based on typical patterns for this category, list the top 10 complaints users have about these tools
   - Group complaints by theme: pricing, UX, missing features, support, reliability
   - Note which complaints appear across multiple competitors (systemic gaps)
   - Identify complaints that represent real opportunities versus minor annoyances

3. UNDERSERVED SEGMENTS
   - Identify customer segments these competitors are not serving well
   - List specific use cases they handle poorly or ignore entirely
   - Find price points and packaging models they do not cover
   - Note geographic or industry verticals with no good option

4. POSITIONING OPPORTUNITIES
   - Suggest 3 specific positioning angles based on the gaps found
   - Angle 1: Feature or audience gap I can fill
   - Angle 2: Price or business model gap I can exploit
   - Angle 3: Experience or simplicity gap I can own

5. UNFAIR ADVANTAGE ASSESSMENT
   - Given my background in [YOUR SKILLS AND EXPERIENCE], which gap can I realistically own?
   - What would it take to become the obvious choice for that gap?
   - What is the fastest path to my first 10 paying customers in that gap?
   - What moat can I build once I own this position?

Be specific and actionable. No generic advice. Every recommendation must connect to a real gap in the competitive landscape.

Be specific to my situation. No generic filler.
