---
name: business-model-canvas
description: Fills out a complete business model canvas for your idea. Use when business model, revenue strategy, business planning, lean canvas, startup strategy.
metadata:
  category: idea-validation
  author: skillar
  version: "1.0"
---

# Business Model Canvas

*Because a startup without a business model is just an expensive hobby.*

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A fully completed 9-block Business Model Canvas tailored to your specific product, plus identification of the single biggest assumption in your model and the fastest way to test it.

## Instructions

You are a business model strategist trained in the Business Model Canvas and Lean Canvas frameworks,.

My product: [PRODUCT DESCRIPTION]
Target customer: [AUDIENCE]
How I make money: [YOUR CURRENT THINKING ON MONETIZATION]

Complete a full Business Model Canvas:

1. CUSTOMER SEGMENTS
   - Who exactly are we creating value for?
   - Rank segments from most valuable to least valuable
   - Identify the single segment to focus on first and why
   - Note which segments to ignore until product-market fit is proven

2. VALUE PROPOSITIONS
   - What specific problems do we solve for each segment?
   - What value do we deliver that alternatives cannot?
   - Why will customers choose us over existing solutions?
   - State the value proposition in one sentence using the customer's language

3. CHANNELS
   - How do we reach our customers at each stage?
   - Phase 1 (0-100 customers): specific tactics and platforms
   - Phase 2 (100-1000 customers): specific tactics and platforms
   - Which channel is cheapest to test right now?

4. CUSTOMER RELATIONSHIPS
   - What type of relationship does each segment expect?
   - How do we acquire new customers (specific mechanism)?
   - How do we retain customers and reduce churn?
   - How do we grow revenue per customer over time?

5. REVENUE STREAMS
   - How does each customer segment pay?
   - Primary revenue model with specific pricing
   - Potential secondary revenue models to add later
   - Rough revenue potential per stream at 100, 500, and 1000 customers

6. KEY RESOURCES
   - What do we need to deliver the value proposition?
   - Technical resources: code, infrastructure, tools
   - Intellectual resources: expertise, data, content
   - Human resources: what I do myself versus what I outsource

7. KEY ACTIVITIES
   - What must I do every single day and week to make this work?
   - Separate: building, selling, supporting, and marketing activities
   - Which activities only I can do versus which I can automate or delegate?

8. KEY PARTNERSHIPS
   - Who can I partner with to reduce risk or cost?
   - What integrations or platforms do I depend on?
   - What should I explicitly NOT build myself?

9. COST STRUCTURE
   - What are the most important fixed and variable costs?
   - Realistic monthly burn rate at launch
   - Break-even point: how many customers at what price?
   - What costs can I eliminate or defer until revenue covers them?

BONUS: Identify the single biggest assumption in this entire model. Design the fastest, cheapest experiment to test it this week.

Be specific to my situation. No generic filler.
