---
name: acquisition-channel-fit
description: Matches your product to the right acquisition channels based on your ICP. Use when growth channels, marketing strategy, acquisition, distribution, go-to-market.
metadata:
  category: idea-validation
  author: skillar
  version: "1.0"
---

# Acquisition Channel Fit

*Because building a great product on the wrong channel is just expensive silence.*

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A scored evaluation of 11 acquisition channels for your specific product and ICP, a ranked top-3 recommendation, a week-by-week 30-day action plan for your best channel, success metrics at 30/60/90 days, and a budget allocation strategy.

## Instructions

You are a growth strategist who has scaled 30+ products from 0 to 10,000 users. You know that channel selection matters more than execution quality in the early days -- the wrong channel with perfect execution still fails.

My product: [PRODUCT DESCRIPTION]
My ICP: [DETAILED CUSTOMER DESCRIPTION]
My budget: [MONTHLY MARKETING BUDGET]
My time available for marketing: [HOURS PER WEEK]
My skills: [WRITING / DESIGN / CODING / VIDEO / OTHER]

Identify the best acquisition channels:

1. CHANNEL ANALYSIS
   - Evaluate each of these channels for my specific product and ICP
   - SEO and content marketing
   - Cold email outreach
   - Twitter/X organic
   - LinkedIn organic
   - Reddit community participation
   - ProductHunt launch
   - Paid social (Meta and LinkedIn ads)
   - Google Ads
   - YouTube content
   - Partnerships and co-marketing
   - App marketplaces and directories
   - For each: fit score 1-10, expected time to first results, estimated cost, and one-sentence reasoning

2. TOP 3 CHANNELS
   - Which 3 channels to start with and a clear explanation of why
   - For each: realistic timeline to first measurable results
   - Which channel to test first, second, and third
   - How much of my time and budget each channel requires
   - What specific skill or asset I need for each

3. 30-DAY ACTION PLAN
   - Week-by-week action plan for my top-ranked channel
   - Week 1: setup, research, and first content or outreach
   - Week 2: publish, test, and iterate
   - Week 3: double down on what works, cut what does not
   - Week 4: measure, analyze, and decide whether to continue or switch
   - Specific posts, emails, or campaigns to create each week

4. SUCCESS METRICS
   - What KPI to track for each of the top 3 channels
   - What "working" looks like at 30 days, 60 days, and 90 days
   - What numbers mean "double down" versus "abandon this channel"
   - How to attribute signups and revenue to each channel

5. BUDGET ALLOCATION
   - How to split [MONTHLY BUDGET] across the top 3 channels
   - What to do if budget is $0 (time-only strategies)
   - When to start spending money versus relying on organic effort
   - How to reallocate budget based on 30-day performance data

Be specific to my product, ICP, budget, and skills. Do not recommend channels that require skills I do not have or budgets I cannot afford.

Be specific to my situation. No generic filler.
