# Skillar Skills Bundle — Start Here

Welcome. You just unlocked 250+ expert-level Claude Skills.

This isn't a collection of one-off prompts. Each skill is a structured, multi-step system designed to deliver real output — the kind that would take hours to create from scratch.

---

## What's Inside

| Product | What's inside | Where |
|---------|--------------|-------|
| Claude Skills Bundle | 250 structured skills across 15 categories | `/skills/` |
| N8N Automation Templates | 1,900+ ready-to-import workflow templates | `/n8n-templates/` |

**Full skills index:** See [SKILL-INDEX.md](/SKILL-INDEX.md) for the complete searchable list.

---

## How to Use a Skill

1. Browse `/skills/` — organized into 15 categories (idea validation, product building, content, sales, etc.)
2. Open any `SKILL.md` file
3. Copy the **Instructions** section
4. Paste into Claude (claude.ai, Claude Code, or any Claude-powered tool)
5. Replace `[BRACKETS]` with your details
6. Get polished, expert-level output

**Works with:** Claude Sonnet, Claude Opus, GPT-4o, and any AI tool that supports markdown skills.

**Pro tip:** In Claude Code, you can use skills as `/slash-commands`. In Cowork and other tools that support the Agent Skills standard, drop the SKILL.md into your project.

---

## 15 Categories (250 Skills)

| # | Category | Skills | Best For |
|---|----------|--------|----------|
| 01 | Idea Validation | 20 | Validating ideas before building |
| 02 | Product Building | 20 | Tech stack, architecture, deployment |
| 03 | Launch & Growth | 20 | Launching and scaling your product |
| 04 | Content & Copy | 25 | Blog posts, landing pages, social copy |
| 05 | Email Automation | 15 | Email sequences that convert |
| 06 | Sales Funnels | 20 | Funnels, pricing pages, sales scripts |
| 07 | SEO & Search | 15 | Ranking higher, keyword research |
| 08 | Ads & Paid Media | 15 | Facebook, Google, TikTok, LinkedIn ads |
| 09 | Social Media | 20 | Growing audience across platforms |
| 10 | Finance & Pricing | 15 | Pricing, financial models, fundraising |
| 11 | Legal & Compliance | 10 | Terms, privacy, contracts |
| 12 | Operations & Systems | 15 | SOPs, hiring, delegation, meetings |
| 13 | AI & Automation | 15 | AI workflows, agents, chatbots |
| 14 | Personal Brand | 15 | Authority building, speaking, newsletters |
| 15 | Analytics & Data | 10 | A/B testing, KPIs, dashboards |

---

## How to Use N8N Templates

1. Open `/n8n-templates/` folder
2. Find a template by category or use Ctrl+F to search by keyword
3. Each template is a `.json` file
4. Open your N8N workspace → **Import** → upload the `.json` file
5. Connect your credentials → activate → done

**Don't have N8N?**
- Cloud version (easiest): n8n.io — free tier available
- Self-hosted (free): install on any VPS in 5 minutes

---

## Updates

This bundle is updated regularly. New skills are added on an ongoing basis.

**Current version:** v2.0
**Skills:** 250
**N8N Templates:** 1,900+

---

## Need help?

Email: support@skillar.io
Twitter: @skillarHQ

**30-day money back guarantee.** If you're not happy — email us.

---

*Thank you for supporting an indie product. Built by a solo founder.*
