# Skillar Skills Bundle — Full Index

> **250 Claude Skills** across 15 categories. Each skill is a structured SKILL.md file with expert-level instructions.
> Copy any skill into Claude, replace [BRACKETS] with your details, get polished output.

---

## Categories

- [01-idea-validation](skills/01-idea-validation/) — 20 skills
- [02-product-building](skills/02-product-building/) — 20 skills
- [03-launch-growth](skills/03-launch-growth/) — 20 skills
- [04-content-copy](skills/04-content-copy/) — 25 skills
- [05-email-automation](skills/05-email-automation/) — 15 skills
- [06-sales-funnels](skills/06-sales-funnels/) — 20 skills
- [07-seo-search](skills/07-seo-search/) — 15 skills
- [08-ads-paid-media](skills/08-ads-paid-media/) — 15 skills
- [09-social-media](skills/09-social-media/) — 20 skills
- [10-finance-pricing](skills/10-finance-pricing/) — 15 skills
- [11-legal-compliance](skills/11-legal-compliance/) — 10 skills
- [12-operations-systems](skills/12-operations-systems/) — 15 skills
- [13-ai-automation](skills/13-ai-automation/) — 15 skills
- [14-personal-brand](skills/14-personal-brand/) — 15 skills
- [15-analytics-data](skills/15-analytics-data/) — 10 skills

**Total: 250 skills**

---

## 01. Idea Validation

1. **acquisition-channel-fit** — Matches your product to the right acquisition channels based on your ICP. Use when growth channels, marketing strategy, acquisition, distribution, go-to-market
2. **assumption-mapping** — Maps all your assumptions and creates a plan to test the riskiest ones first. Use when assumption testing, de-risking, lean startup, hypothesis mapping
3. **build-or-not-framework** — Runs your idea through a structured go/no-go decision framework. Use when idea evaluation, should I build this, go no-go decision, idea scoring
4. **business-model-canvas** — Fills out a complete business model canvas for your idea. Use when business model, revenue strategy, business planning, lean canvas, startup strategy
5. **competitor-gap-analysis** — Finds underserved opportunities your competitors are missing. Use when competitive analysis, market gaps, positioning, differentiation
6. **fake-door-test** — Sets up a complete fake door test to validate willingness to pay before building. Use when fake door test, pre-launch validation, demand testing, willingness to pay
7. **icp-deep-dive** — Builds a complete Ideal Customer Profile for any product idea. Use when defining target audience, customer research, ICP, buyer persona
8. **jobs-to-be-done** — Applies the JTBD framework to uncover true customer motivations behind your product. Use when jobs to be done, JTBD, customer motivation, product positioning, messaging
9. **landing-page-copy** — Writes complete landing page copy for a product that doesn't exist yet. Use when landing page, pre-launch copy, waitlist page, conversion copywriting
10. **micro-saas-playbook** — Step-by-step validation plan for a micro-SaaS idea in 2 weeks. Use when micro-SaaS validation, 2-week sprint, validation playbook, SaaS validation
11. **mvp-scope** — Ruthlessly cuts your feature list to the smallest possible MVP. Use when MVP definition, feature prioritization, scope creep, what to build first
12. **niche-down-advisor** — Takes a broad idea and finds the most profitable niche to start with. Use when niche selection, narrowing focus, target market, positioning strategy
13. **one-line-pitch** — Creates multiple versions of your elevator pitch for different contexts. Use when elevator pitch, tagline, positioning copy, product description, Twitter bio
14. **pre-mortem-analysis** — Imagines your idea has failed and works backwards to find the real risks. Use when risk assessment, pre-mortem, failure analysis, idea stress test
15. **pricing-experiment** — Designs a pricing test to find your optimal price point before launch. Use when pricing strategy, willingness to pay, price testing, monetization
16. **problem-validation** — Creates a customer discovery interview script to validate your idea before building. Use when customer interviews, problem validation, discovery calls, user research
17. **reddit-validation** — Generates a Reddit research plan to validate demand without building anything. Use when Reddit research, community validation, demand testing, quick validation
18. **survey-design** — Writes a customer survey you can distribute in communities today. Use when survey design, customer research, quantitative validation, market research
19. **waitlist-email-sequence** — Writes a 5-email nurture sequence for waitlist subscribers before launch. Use when waitlist emails, pre-launch sequence, email nurture, launch emails
20. **why-now-narrative** — Builds the market timing argument for why your idea is inevitable right now. Use when market timing, why now, pitch narrative, launch story, investor pitch

## 02. Product Building

1. **api-architecture** — Plans RESTful or GraphQL API with endpoints, auth, versioning, rate limiting. Use when designing APIs, planning backend routes, structuring microservices, or building integrations
2. **api-documentation** — Generates API documentation with examples, error codes, and authentication guide. Use when documenting endpoints, creating API references, writing developer guides, or building API portals
3. **auth-system-design** — Designs authentication and authorization system with JWT, OAuth, sessions, RBAC. Use when building login systems, setting up user permissions, implementing SSO, or securing APIs
4. **ci-cd-pipeline** — Sets up CI/CD pipeline with testing, staging, deployment steps. Use when automating deployments, configuring GitHub Actions, setting up continuous integration, or building release workflows
5. **code-review-checklist** — Creates comprehensive code review checklist customized to your stack. Use when establishing review standards, onboarding reviewers, improving code quality, or creating PR templates
6. **database-schema-design** — Designs database schema with tables, relationships, indexes for any product. Use when modeling data, creating tables, planning database structure, or setting up a new database
7. **deployment-checklist** — Pre-deployment checklist covering security, performance, monitoring, rollback. Use when launching products, deploying to production, preparing releases, or doing go-live checks
8. **developer-onboarding** — Creates developer onboarding docs and setup guide for your project. Use when hiring new devs, writing setup instructions, documenting architecture, or reducing ramp-up time
9. **error-handling-strategy** — Designs error handling patterns for user-facing errors, logging, alerting, recovery. Use when standardizing error handling, reducing noisy logs, improving user experience on failures, or debugging production issues
10. **feature-prioritization** — Prioritizes features using RICE/ICE scoring for your product roadmap. Use when planning sprints, deciding what to build next, managing backlogs, or aligning team on priorities
11. **logging-monitoring** — Sets up logging and monitoring stack with alerting rules and dashboards. Use when adding observability, configuring alerts, setting up log aggregation, or building operational dashboards
12. **migration-plan** — Plans database or system migration with zero-downtime strategy. Use when changing databases, migrating infrastructure, switching providers, or upgrading major versions
13. **mvp-architecture** — Designs minimal viable architecture that scales from 0 to 10k users. Use when starting a new product, planning initial system design, or deciding what to build vs buy
14. **no-code-prototype** — Plans a no-code prototype using Bubble, Webflow, Airtable to validate before coding. Use when testing ideas fast, building without code, creating clickable prototypes, or validating demand
15. **performance-audit** — Audits app performance and provides optimization roadmap. Use when diagnosing slow pages, reducing load times, optimizing queries, or improving Core Web Vitals
16. **scalability-roadmap** — Creates scaling plan from MVP to 100k users with infrastructure decisions. Use when planning for growth, hitting performance limits, preparing for traffic spikes, or designing for scale
17. **security-audit** — Security audit checklist covering OWASP top 10, auth, data protection, infrastructure. Use when hardening security, preparing for penetration testing, handling sensitive data, or achieving compliance
18. **tech-stack-selector** — Recommends optimal tech stack based on product requirements, team size, and constraints. Use when choosing technologies, starting a new project, evaluating frameworks, or comparing tech options
19. **technical-debt-audit** — Audits codebase for technical debt and creates prioritized remediation plan. Use when codebase feels slow, refactoring decisions, legacy code cleanup, or sprint planning for tech debt
20. **testing-strategy** — Designs testing strategy covering unit, integration, e2e, what to test and what to skip. Use when setting up tests, choosing testing frameworks, improving coverage, or building test infrastructure

## 03. Launch Growth

1. **app-store-optimization** — Optimizes app store listing with title, description, screenshots, and keywords. Use when optimizing App Store or Google Play listings, improving app visibility, increasing download conversions, or researching app keywords
2. **beta-launch-plan** — Plans beta launch with invite strategy, feedback loops, and success criteria. Use when launching a beta, planning early access, managing beta testers, or designing feedback systems
3. **community-building** — Plans community strategy with platform, content cadence, and engagement tactics. Use when building a community, launching a Discord or forum, planning community content, or increasing user engagement
4. **early-adopter-program** — Creates an early adopter or founding member program with incentives. Use when designing founding member tiers, early adopter rewards, VIP access programs, or loyalty incentives for first users
5. **feedback-collection** — Designs feedback collection system with surveys, interviews, NPS, and in-app methods. Use when setting up user feedback, designing surveys, planning customer interviews, or building feedback loops
6. **growth-experiment** — Designs a growth experiment with hypothesis, test plan, and success criteria. Use when running growth tests, A/B experiments, optimizing funnels, or validating growth tactics
7. **influencer-brief** — Creates influencer collaboration brief with deliverables and messaging. Use when working with influencers, planning creator partnerships, briefing content creators, or designing influencer campaigns
8. **launch-day-playbook** — Hour-by-hour launch day plan with all posts, emails, and actions. Use when preparing for launch day, coordinating launch activities, or planning day-of execution
9. **launch-email-blast** — Writes launch announcement email for your full list with segmentation. Use when writing launch emails, announcing product releases, sending email blasts, or segmenting launch communications
10. **marketplace-listing** — Optimizes marketplace listing for AppSumo, Gumroad, and similar platforms for conversions. Use when listing on marketplaces, optimizing product pages, writing sales copy for platforms, or increasing marketplace conversions
11. **partnership-outreach** — Creates partnership outreach templates and strategy for co-marketing. Use when reaching out to partners, planning co-marketing campaigns, building strategic alliances, or creating integration partnerships
12. **post-launch-analysis** — Framework for analyzing launch results and deciding next moves. Use when evaluating launch performance, conducting post-mortems, or planning post-launch strategy
13. **pre-launch-checklist** — Comprehensive checklist for everything needed before going live. Use when preparing to launch, auditing launch readiness, or ensuring nothing is missed before go-live
14. **press-kit** — Builds a complete press kit with bio, product info, assets, and pitch angles. Use when creating a press kit, preparing for media outreach, assembling PR materials, or pitching journalists
15. **product-hunt-launch** — Complete Product Hunt launch playbook with timeline, copy, and community strategy. Use when launching on Product Hunt, planning PH campaign, preparing hunt day, or optimizing PH listing
16. **referral-program** — Designs referral program with mechanics, incentives, and viral coefficient. Use when building referral systems, creating word-of-mouth loops, designing invite programs, or increasing viral growth
17. **relaunch-plan** — Plans product relaunch after updates or pivot with fresh positioning. Use when relaunching a product, repositioning after pivot, announcing major updates, or reintroducing to the market
18. **retention-strategy** — Creates retention plan covering onboarding, engagement, and win-back for first 90 days. Use when reducing churn, improving retention, designing onboarding, or building engagement loops
19. **viral-loop-design** — Engineers viral loops into your product for organic growth. Use when designing viral mechanics, building network effects, creating shareability, or engineering organic distribution
20. **waitlist-builder** — Designs a waitlist strategy that builds hype and converts to customers. Use when building a waitlist, pre-launch sign-ups, generating early demand, or creating urgency before launch

## 04. Content Copy

1. **about-page** — Creates authentic About page with brand story and team narrative. Use when writing company about pages, crafting brand origin stories, redesigning website about sections
2. **blog-post** — Writes SEO-optimized blog post with hook, structure, and CTA. Use when writing blog articles, creating website content, publishing thought leadership posts
3. **brand-voice-guide** — Defines brand voice with tone, vocabulary, and examples. Use when establishing brand guidelines, onboarding writers, standardizing marketing communications
4. **call-to-action-writer** — Creates CTAs for different contexts including buttons, banners, emails, and pages. Use when writing conversion copy, optimizing landing pages, improving click-through rates
5. **case-study** — Writes customer case study with problem-solution-results format. Use when creating customer success stories, building social proof assets, showcasing ROI outcomes
6. **comparison-page** — Writes competitor comparison page that positions you favorably. Use when creating versus pages, building competitive landing pages, handling competitor objections
7. **content-brief** — Writes detailed content brief for writers and freelancers. Use when assigning content to writers, briefing freelancers, standardizing content production workflow
8. **content-calendar** — Builds 30-day content calendar with topics, formats, and channels. Use when planning content strategy, organizing publishing schedule, managing editorial workflow
9. **faq-page** — Generates FAQ page that addresses objections and improves SEO. Use when building FAQ sections, handling customer objections, creating help center content
10. **guest-post-pitch** — Crafts pitch emails for guest posting on industry publications. Use when pitching guest articles, building backlinks, getting published on authority sites
11. **headline-generator** — Generates 20+ headline variations with proven formulas. Use when writing blog titles, creating ad headlines, testing subject lines, brainstorming content hooks
12. **hook-writer** — Creates scroll-stopping hooks for social media, emails, and landing pages. Use when writing opening lines, crafting attention grabbers, improving content engagement rates
13. **lead-magnet** — Designs and outlines lead magnet content such as ebooks, checklists, and templates. Use when creating gated content, building email lists, generating marketing qualified leads
14. **linkedin-post** — Writes LinkedIn post optimized for algorithm and engagement. Use when creating LinkedIn content, building professional brand, sharing business insights on LinkedIn
15. **microcopy-audit** — Audits and rewrites UI microcopy including buttons, tooltips, errors, and empty states. Use when improving UX writing, polishing app copy, reducing user friction in interfaces
16. **newsletter-issue** — Writes engaging newsletter issue with intro, body, and CTA. Use when creating email newsletters, writing subscriber updates, building audience engagement campaigns
17. **pillar-page** — Creates comprehensive pillar page (3000+ word guide) for SEO authority. Use when building topic clusters, creating cornerstone content, establishing thought leadership hubs
18. **press-release** — Writes press release for product launch or company news. Use when announcing launches, sharing company milestones, distributing media announcements
19. **product-description** — Writes compelling product description for any channel. Use when creating ecommerce listings, writing product page copy, launching new products
20. **repurposing-plan** — Creates plan to repurpose one piece of content into 10+ formats. Use when maximizing content ROI, creating derivative content, scaling content output efficiently
21. **seo-article** — Creates SEO-first article targeting specific keywords. Use when writing search-optimized content, targeting keyword rankings, building organic traffic
22. **storytelling-framework** — Builds brand storytelling framework using hero's journey. Use when developing brand narrative, creating origin stories, building emotional brand connection
23. **testimonial-request** — Creates email template to collect powerful testimonials from customers. Use when gathering social proof, requesting customer reviews, building testimonial campaigns
24. **twitter-thread** — Creates viral Twitter/X thread with hooks and engagement hooks. Use when writing tweet storms, creating social media threads, building audience on X/Twitter
25. **white-paper** — Creates authoritative white paper on industry topic. Use when producing thought leadership documents, generating leads with gated content, establishing expertise

## 05. Email Automation

1. **abandoned-cart-email** — Creates a 3-email abandoned cart recovery sequence with urgency and incentives. Use when building cart abandonment flows, recovering lost sales, or setting up ecommerce email automation
2. **annual-review-email** — Creates a year-in-review email showing user stats and achievements. Use when building annual recap emails, personalized yearly summaries, or end-of-year engagement campaigns
3. **black-friday-campaign** — Creates a Black Friday or holiday email campaign with teaser, launch, and last chance emails. Use when planning seasonal sales campaigns, holiday email sequences, or high-urgency promotional series
4. **churn-prevention-email** — Creates a churn prevention email triggered by disengagement signals. Use when building retention flows, reducing subscriber churn, or responding to at-risk user behavior with automated emails
5. **feedback-request-email** — Creates a customer feedback request email with high response rate tactics. Use when soliciting reviews, running NPS surveys, collecting testimonials, or gathering post-purchase feedback
6. **launch-announcement** — Writes a product launch email with hype, benefits, and limited-time offer. Use when announcing new products, releasing features, or creating launch day email campaigns
7. **milestone-email** — Creates a celebratory milestone email for user achievements. Use when congratulating users on accomplishments, marking usage milestones, or building loyalty through recognition emails
8. **newsletter-template** — Generates a reusable newsletter template with sections and formatting. Use when building recurring newsletters, designing email digest layouts, or creating branded newsletter frameworks
9. **nurture-sequence** — Builds a 7-email nurture sequence that develops trust and guides subscribers to purchase. Use when creating drip campaigns, lead nurturing flows, or educational email series that convert
10. **onboarding-sequence** — Builds a SaaS onboarding email series guiding users to activation milestone. Use when creating user onboarding flows, product adoption sequences, or trial-to-paid conversion emails
11. **re-engagement-campaign** — Creates a win-back email series for inactive subscribers. Use when re-engaging cold subscribers, cleaning email lists, or building reactivation campaigns for dormant contacts
12. **referral-email** — Writes a referral request email with incentive structure and easy sharing. Use when building referral programs, creating refer-a-friend campaigns, or driving word-of-mouth growth via email
13. **upsell-email** — Writes a post-purchase upsell email that feels helpful not pushy. Use when creating upsell flows, cross-sell campaigns, or post-purchase email automation sequences
14. **webinar-invite** — Creates a webinar invitation email sequence with invite, reminder, and follow-up. Use when promoting webinars, live events, online workshops, or virtual summit sessions via email
15. **welcome-sequence** — Generates a 5-email welcome sequence for new subscribers. Use when onboarding new email subscribers, setting up welcome drip, or creating a nurture intro series with calls-to-action

## 06. Sales Funnels

1. **closing-script** — Writes closing scripts for different sales scenarios. Use when creating sales close, deal closing language, final pitch, negotiation close, or ask-for-the-sale scripts
2. **consultation-funnel** — Creates consultation booking funnel for service businesses. Use when building appointment funnel, discovery call funnel, booking page, or service-based lead generation
3. **contract-template** — Creates freelancer or agency contract template with key clauses. Use when writing service agreement, client contract, freelance agreement, project terms, or agency retainer contract
4. **demo-script** — Creates product demo script that highlights value and handles objections. Use when writing demo presentation, product walkthrough, software demo, or sales demonstration script
5. **discovery-call-script** — Writes discovery or sales call script with qualifying questions. Use when creating sales call framework, consultation script, qualifying call guide, or phone sales process
6. **downsell-strategy** — Designs downsell offer for prospects who decline main offer. Use when creating fallback offer, budget alternative, exit offer, or save-the-sale strategy
7. **follow-up-sequence** — Designs follow-up sequence for leads who did not convert. Use when creating nurture sequence, re-engagement emails, lead follow-up, or sales cadence for unconverted prospects
8. **free-trial-funnel** — Designs free trial funnel with activation and conversion touchpoints. Use when creating trial offer, freemium funnel, SaaS trial strategy, or try-before-you-buy conversion path
9. **high-ticket-offer** — Structures high-ticket offer ($1k+) with positioning and delivery. Use when creating premium offer, high-ticket program, luxury positioning, or coaching package above $1000
10. **lead-magnet-funnel** — Builds lead magnet funnel including opt-in page, delivery, and follow-up. Use when creating lead generation funnel, freebie funnel, email list builder, or opt-in strategy
11. **objection-handler** — Maps all objections and creates response scripts for each. Use when handling sales objections, overcoming buyer resistance, creating rebuttals, or preparing for prospect pushback
12. **order-bump-strategy** — Designs order bump offers to increase average order value. Use when creating checkout add-on, order bump, cart enhancement, or average order value optimization
13. **pricing-page** — Designs pricing page with tier strategy and comparison table. Use when creating pricing structure, plan comparison, subscription tiers, or package pricing display
14. **proposal-writer** — Creates client proposal template with pricing and scope. Use when writing business proposal, project quote, service agreement, scope of work, or client pitch document
15. **roi-calculator** — Builds ROI calculator framework showing customer return on investment. Use when creating value calculator, cost-benefit analysis, investment justification tool, or savings estimator
16. **sales-funnel-builder** — Designs complete sales funnel from awareness to purchase. Use when building a funnel, mapping customer journey, creating conversion path, or planning sales pipeline stages
17. **sales-page-copy** — Writes long-form sales page with all conversion elements. Use when creating sales letter, landing page copy, product page, or direct response sales page
18. **tripwire-offer** — Creates low-price tripwire offer to convert leads into buyers. Use when designing entry-level offer, low-ticket product, micro-commitment strategy, or buyer conversion funnel
19. **upsell-page** — Creates post-purchase upsell page with one-click buy. Use when designing upsell offer, one-time offer, post-checkout page, or revenue maximization after purchase
20. **webinar-sales-script** — Writes webinar script that educates and converts to purchase. Use when creating webinar presentation, live selling event, automated webinar funnel, or pitch deck for online training

## 07. Seo Search

1. **backlink-strategy** — Creates a backlink acquisition plan with outreach templates and link-worthy asset ideas. Use when building domain authority, launching link building campaigns, or struggling to get quality backlinks
2. **competitor-seo-analysis** — Analyzes competitor SEO strategy including keywords, backlinks, and content approach. Use when entering a new market, losing rankings to a competitor, or reverse-engineering what is working in your niche
3. **content-gap-analysis** — Finds content gaps vs competitors to prioritize what to write next. Use when planning a content calendar, running out of topic ideas, or losing rankings to competitors with better coverage
4. **featured-snippet-optimizer** — Optimizes content to win featured snippets and position zero. Use when targeting answer boxes, trying to outrank competitors with snippets, or reformatting content for SERP features
5. **internal-linking-strategy** — Plans internal linking structure for SEO authority distribution. Use when building topic clusters, improving crawlability, boosting underperforming pages, or restructuring site navigation
6. **keyword-research** — Finds high-value keywords with search volume, difficulty, and intent mapping. Use when planning content strategy, launching a new site, entering a new niche, or deciding what to write next
7. **link-building-outreach** — Writes link building outreach emails that actually get responses. Use when reaching out for backlinks, pitching guest posts, requesting resource page inclusions, or running any link acquisition campaign
8. **local-seo-plan** — Local SEO optimization plan for businesses targeting geographic areas. Use when setting up Google Business Profile, improving local rankings, or expanding to new locations
9. **rank-tracking-plan** — Sets up a rank tracking system with KPIs and reporting cadence. Use when starting SEO tracking, building dashboards, reporting to stakeholders, or measuring SEO campaign effectiveness
10. **schema-markup** — Generates schema markup (JSON-LD) for any page type. Use when adding structured data, fixing rich result errors, or implementing schema for products, articles, FAQs, local businesses, or events
11. **seo-audit** — Full technical and on-page SEO audit with prioritized fix list. Use when traffic drops, launching a new site, before a redesign, or for quarterly SEO health checks
12. **seo-content-brief** — Creates SEO content briefs for writers with keywords, structure, and intent. Use when assigning articles to writers, planning blog posts, or ensuring content is optimized before writing begins
13. **seo-migration-checklist** — SEO migration checklist for domain changes, redesigns, and platform moves. Use when changing domains, moving to a new CMS, redesigning your site, merging sites, or switching URL structures
14. **site-speed-audit** — Site speed audit with specific optimization recommendations. Use when pages load slowly, Core Web Vitals fail, PageSpeed scores are low, or users complain about performance
15. **technical-seo-checklist** — Technical SEO checklist covering crawlability, indexing, speed, and structured data. Use when launching a site, debugging indexing issues, or performing routine technical maintenance

## 08. Ads Paid Media

1. **a-b-test-ads** — Designs an A/B test plan for ad creative, copy, and targeting. Use when planning ad experiments, testing ad variations, optimizing creative performance, or setting up split tests in ad platforms
2. **ad-copy-variants** — Generates 10+ ad copy variants for A/B testing across platforms. Use when writing ad copy, creating ad variations, testing headlines, or scaling ad creative with fresh copy angles
3. **ad-creative-brief** — Creates a creative brief for ad designers with messaging, visuals, and specs. Use when briefing designers on ad creative, aligning team on ad visuals, or commissioning ad design work
4. **audience-targeting** — Builds a detailed audience targeting strategy with lookalikes and custom audiences. Use when defining ad audiences, building lookalike audiences, segmenting customers for ads, or improving targeting precision
5. **budget-allocation-plan** — Allocates ad budget across channels based on goals and data. Use when planning media spend, dividing budget across platforms, justifying ad spend allocation, or rebalancing marketing budget
6. **campaign-audit** — Audits existing ad campaigns for wasted spend and optimization opportunities. Use when campaigns underperform, ad costs are rising, ROAS is declining, or before scaling ad spend
7. **conversion-tracking-setup** — Sets up conversion tracking across platforms with attribution. Use when implementing tracking pixels, fixing broken conversion data, setting up Meta CAPI, configuring Google Ads conversions, or aligning attribution across channels
8. **facebook-ad-campaign** — Builds a complete Facebook/Meta ad campaign with targeting, copy, and creative brief. Use when launching Facebook ads, setting up Meta campaigns, planning Instagram promotions, or structuring ad sets
9. **google-ads-campaign** — Structures a Google Ads campaign with keywords, ad groups, and bidding strategy. Use when setting up Google search ads, planning PPC campaigns, organizing ad groups, or choosing bidding strategies
10. **influencer-ad-brief** — Creates a brief for influencer-produced ad content with deliverables. Use when hiring influencers for ads, briefing creators on sponsored content, planning UGC ad campaigns, or managing influencer partnerships for paid amplification
11. **landing-page-for-ads** — Designs a landing page optimized for paid traffic with message match. Use when building landing pages for ads, improving ad-to-page conversion, reducing bounce rate on paid traffic, or launching campaign-specific pages
12. **linkedin-ad-campaign** — Builds a LinkedIn ad campaign for B2B targeting with InMail and sponsored content. Use when running LinkedIn ads, targeting B2B audiences, creating sponsored posts, or launching InMail campaigns
13. **retargeting-strategy** — Designs a retargeting campaign across platforms with audience segmentation. Use when setting up retargeting, creating remarketing audiences, recovering abandoned carts, or re-engaging website visitors
14. **tiktok-ad-script** — Writes a TikTok ad script that feels native and converts. Use when creating TikTok ads, scripting short-form video ads, planning Spark Ads, or producing UGC-style ad content
15. **youtube-ad-script** — Writes a YouTube ad script for pre-roll, mid-roll, or bumper ads with hook and CTA. Use when creating YouTube ads, writing video ad scripts, planning pre-roll campaigns, or producing YouTube discovery ads

## 09. Social Media

1. **brand-collab-pitch** — Creates pitch templates for brand collaborations and sponsorships. Use when reaching out to brands, pitching sponsorships, or proposing influencer partnerships
2. **community-management** — Creates a community management playbook with engagement rules and crisis handling. Use when building an online community, managing social media interactions, or handling community crises
3. **content-repurposer** — Creates a system for repurposing one piece of content across all platforms. Use when maximizing content ROI, adapting content for multiple channels, or building a content multiplication workflow
4. **engagement-playbook** — Creates a daily engagement routine that builds followers and relationships. Use when struggling with low engagement, needing a commenting strategy, or building genuine connections on social media
5. **hashtag-strategy** — Develops a hashtag research and strategy for maximum reach on any platform. Use when optimizing hashtags, increasing post reach, or building a hashtag system for content
6. **instagram-carousel** — Creates Instagram carousel posts with slide-by-slide copy, visuals, and CTA. Use when you need carousel content, Instagram slides, swipeable posts, or educational Instagram content
7. **linkedin-strategy** — Builds a LinkedIn growth strategy for B2B founders and professionals. Use when growing a LinkedIn presence, generating leads on LinkedIn, or building thought leadership
8. **live-stream-plan** — Creates a live stream plan with topic, structure, engagement tactics, and repurposing. Use when planning a live stream, going live on social media, or building a live content strategy
9. **platform-launch-plan** — Creates a strategy for launching your brand on a new social platform. Use when joining a new social network, expanding to a new platform, or building a presence from scratch
10. **podcast-launch** — Creates a podcast launch plan covering format, equipment, guests, distribution, and growth. Use when starting a podcast, planning a show, or launching an audio content strategy
11. **reddit-marketing** — Creates a Reddit marketing strategy that builds reputation without getting banned. Use when marketing on Reddit, building community presence, or driving traffic from Reddit
12. **short-form-video-script** — Writes scripts for Reels, Shorts, and TikTok with hooks and storytelling. Use when creating short-form video content, scripting Reels, or writing TikTok scripts
13. **social-media-audit** — Audits all social profiles for optimization opportunities. Use when reviewing social media performance, identifying growth gaps, or benchmarking against competitors
14. **social-media-calendar** — Creates a 30-day social media calendar across all platforms. Use when planning monthly social content, coordinating cross-platform posts, or building a content schedule
15. **social-proof-collection** — Builds a system for collecting and displaying social proof across channels. Use when gathering testimonials, showcasing reviews, or building trust through customer evidence
16. **tiktok-content-plan** — Creates a 30-day TikTok content plan with hooks, trends, and posting schedule. Use when planning TikTok content, building a TikTok presence, or chasing viral short-form video
17. **twitter-growth-plan** — Creates a Twitter/X growth plan with content types, engagement strategy, and threads. Use when growing on Twitter, building an audience on X, or creating a tweeting strategy
18. **ugc-campaign** — Designs a user-generated content campaign with incentives and collection workflow. Use when launching a UGC campaign, encouraging customer content, or building social proof through real users
19. **viral-content-formula** — Reverse-engineers viral content patterns for any niche. Use when you want to create viral posts, understand what makes content spread, or decode trending formats
20. **youtube-strategy** — Creates a complete YouTube channel strategy with content pillars, growth plan, and optimization. Use when launching a YouTube channel, planning video content, or scaling YouTube growth

## 10. Finance Pricing

1. **budget-planner** — Creates monthly operating budget with categories and tracking framework. Use when creating budget, planning expenses, monthly budget, operating budget, expense planning, financial planning
2. **burn-rate-analysis** — Analyzes burn rate with cost optimization recommendations. Use when analyzing burn rate, reducing costs, optimizing spend, cutting expenses, startup cost management
3. **cap-table** — Designs cap table structure with founder splits, ESOP, and investor scenarios. Use when building cap table, equity splits, founder equity, stock options, ESOP planning, dilution modeling
4. **churn-analysis** — Analyzes churn patterns and creates reduction strategy. Use when analyzing churn, reducing customer churn, retention strategy, customer attrition, churn prevention, improving retention
5. **financial-model** — Builds a comprehensive financial model with revenue projections, cost structures, and key assumptions. Use when building financial model, projecting revenue, modeling costs, planning finances, creating pro forma
6. **freemium-strategy** — Designs freemium model with free/paid boundary and conversion triggers. Use when designing freemium pricing, free tier strategy, free-to-paid conversion, product-led growth, PLG pricing
7. **fundraising-pitch** — Creates fundraising pitch deck outline with key slides and narrative. Use when raising funding, creating pitch deck, investor presentation, fundraising narrative, Series A deck, seed pitch
8. **invoice-template** — Creates professional invoice template with payment terms and branding. Use when creating invoices, billing clients, invoice design, payment terms, freelance billing, client invoicing
9. **ltv-cac-optimizer** — Optimizes LTV:CAC ratio with specific levers to pull. Use when improving LTV CAC ratio, optimizing acquisition efficiency, customer lifetime value, acquisition cost reduction, growth efficiency
10. **payment-optimization** — Optimizes payment flow to reduce failed payments and increase conversion. Use when improving payment conversion, reducing payment failures, checkout optimization, dunning strategy, reducing involuntary churn
11. **pricing-strategy** — Designs pricing strategy with tiers, anchoring, and competitive positioning. Use when setting prices, creating pricing tiers, competitive pricing, value-based pricing, pricing page design
12. **revenue-forecast** — Creates a 12-month revenue forecast with pessimistic, realistic, and optimistic scenarios. Use when forecasting revenue, projecting sales, planning revenue targets, modeling growth scenarios
13. **runway-calculator** — Calculates startup runway with burn rate scenarios and extension tactics. Use when calculating runway, burn rate analysis, cash management, extending runway, startup cash planning
14. **subscription-model** — Structures subscription pricing with tiers, features, and upgrade paths. Use when designing subscription plans, recurring revenue model, SaaS pricing, membership tiers, subscription billing
15. **unit-economics** — Calculates unit economics including CAC, LTV, margins, and payback period. Use when analyzing unit economics, calculating CAC, computing LTV, measuring payback period, evaluating margins

## 11. Legal Compliance

1. **contractor-agreement** — Creates a freelancer or independent contractor agreement with scope, payment, and IP provisions. Use when hiring freelancers, engaging consultants, outsourcing development, or formalizing contractor relationships
2. **cookie-policy** — Creates a cookie policy with consent banner copy and cookie categories. Use when adding cookie consent to a website, preparing for ePrivacy compliance, updating tracking practices, or implementing a consent management platform
3. **dmca-response** — Creates DMCA takedown notice and counter-notice templates for copyright disputes. Use when filing a copyright takedown, responding to infringement claims, protecting original content, or handling user-generated content disputes
4. **gdpr-compliance-checklist** — Creates a GDPR compliance checklist with action items for each requirement. Use when preparing for GDPR compliance, auditing data practices, expanding to EU markets, or building a privacy program
5. **intellectual-property-audit** — Audits IP assets and creates a protection strategy for startups and digital businesses. Use when assessing IP portfolio, preparing for fundraising, evaluating trademark needs, or building an IP protection plan
6. **nda-template** — Creates a mutual NDA template for business discussions and partnerships. Use when sharing confidential information, entering partnership talks, hiring consultants, or beginning investor discussions
7. **privacy-policy** — Creates a GDPR and CCPA-compliant privacy policy for any digital product. Use when launching an app, collecting user data, updating privacy pages, or preparing for compliance audits
8. **refund-policy** — Writes a clear refund and cancellation policy for digital products and services. Use when launching a SaaS product, selling digital goods, setting up subscription billing, or updating return policies
9. **saas-agreement** — Writes a SaaS subscription agreement with usage terms, SLA, and data handling provisions. Use when selling software subscriptions, onboarding enterprise clients, or formalizing SaaS contracts
10. **terms-of-service** — Generates Terms of Service for SaaS or web applications with key legal clauses. Use when launching a product, updating legal pages, drafting website terms, or creating user agreements

## 12. Operations Systems

1. **automation-workflow** — Designs automation workflows with triggers, actions, and tool recommendations. Use when automating repetitive tasks, building Zapier flows, setting up integrations, or eliminating manual busywork
2. **contractor-brief** — Writes detailed briefs for freelancers and contractors with scope and deliverables. Use when hiring freelancers, outsourcing work, writing project briefs, or scoping contractor engagements
3. **decision-framework** — Creates decision frameworks for recurring business decisions. Use when making tough calls, choosing between options, building decision matrices, or reducing decision fatigue
4. **delegation-playbook** — Builds a delegation system covering what to delegate, to whom, and how to brief. Use when overwhelmed, becoming a bottleneck, scaling yourself, training team members, or freeing up founder time
5. **documentation-system** — Designs a documentation system for internal knowledge management. Use when building a company wiki, organizing internal docs, reducing tribal knowledge, or creating a team handbook
6. **hiring-plan** — Creates a hiring plan with job description, interview questions, and scorecard. Use when recruiting, writing job posts, designing interviews, or evaluating candidates
7. **incident-response** — Creates incident response plans for outages, security issues, and PR crises. Use when preparing for emergencies, building runbooks, handling downtime, or managing security breaches
8. **meeting-agenda** — Designs effective meeting agenda templates for different meeting types. Use when planning meetings, improving meeting culture, creating standup formats, or reducing wasted meeting time
9. **okr-builder** — Sets up OKRs (Objectives and Key Results) for quarterly planning. Use when setting goals, doing quarterly planning, aligning team priorities, or defining measurable targets
10. **onboarding-checklist** — Creates employee or contractor onboarding checklists with first 30 days mapped out. Use when hiring new team members, building onboarding programs, creating first-week plans, or reducing new-hire ramp time
11. **quarterly-review** — Creates quarterly business review templates with metrics and action items. Use when running QBRs, reviewing business performance, planning next quarter, or presenting to stakeholders
12. **remote-team-setup** — Sets up remote team infrastructure with tools, processes, and communication norms. Use when going remote, hiring distributed teams, fixing remote culture, or setting up async workflows
13. **sop-builder** — Creates a standard operating procedure for any recurring process. Use when documenting workflows, writing SOPs, standardizing processes, creating step-by-step guides, or building runbooks
14. **time-audit** — Analyzes time allocation and recommends optimization priorities. Use when feeling overwhelmed, tracking where time goes, improving productivity, or identifying time wasters
15. **tool-stack-audit** — Audits current tool stack for redundancy, cost savings, and gaps. Use when reviewing software subscriptions, consolidating tools, cutting SaaS costs, or evaluating new tools

## 13. Ai Automation

1. **ai-agent-design** — Designs autonomous AI agents with goals, tools, and guardrails. Use when building AI agents, creating autonomous workflows, or designing multi-agent systems
2. **ai-code-reviewer** — Sets up AI code review workflows with quality standards. Use when automating code reviews, enforcing coding standards, or improving code quality processes
3. **ai-content-pipeline** — Creates AI-assisted content production pipelines. Use when scaling content creation, building editorial workflows, or automating content repurposing
4. **ai-customer-support** — Designs AI-powered customer support systems with escalation rules. Use when automating support tickets, building help desk AI, or reducing support response times
5. **ai-email-writer** — Creates AI email writing systems with templates and tone matching. Use when automating email drafting, building email templates, or standardizing team email communication
6. **ai-image-prompt** — Writes detailed image generation prompts for any visual need. Use when creating AI art, generating marketing visuals, or writing prompts for Midjourney, DALL-E, or Stable Diffusion
7. **ai-research-assistant** — Designs AI research assistants for market research and analysis. Use when automating research workflows, building competitive intelligence systems, or structuring AI-powered analysis
8. **ai-sales-assistant** — Creates AI sales assistants for lead qualification and follow-up. Use when automating lead scoring, building sales outreach sequences, or designing AI-powered sales workflows
9. **ai-use-case-finder** — Identifies highest-ROI AI use cases for any business. Use when evaluating AI opportunities, prioritizing automation projects, or building an AI roadmap
10. **ai-voice-assistant** — Designs voice assistant workflows with speech-to-text and response logic. Use when building voice interfaces, creating IVR systems, or designing voice-first AI experiences
11. **ai-workflow-design** — Designs AI-powered workflows with tools, triggers, and handoffs. Use when automating business processes, connecting AI to existing systems, or building multi-step AI pipelines
12. **chatbot-builder** — Plans customer-facing chatbots with conversation flows and personality. Use when building chatbots, designing conversational AI, or creating virtual assistants
13. **data-extraction-workflow** — Builds data extraction workflows from documents, emails, or web sources. Use when automating data entry, parsing unstructured documents, or extracting information at scale
14. **prompt-library-builder** — Builds an organized prompt library for team or personal use. Use when creating prompt templates, standardizing AI usage, or onboarding teams to AI tools
15. **tool-stack-audit-ai** — Audits opportunities to add AI to an existing tool stack. Use when evaluating AI integrations, modernizing workflows, or reducing manual work across business tools

## 14. Personal Brand

1. **authority-content-plan** — Plans an authority-building content strategy to establish industry expertise and thought leadership. Use when building authority, establishing expertise, creating expert content, becoming a thought leader
2. **bio-writer** — Writes professional bios for different contexts including social media, speaker intros, and press kits. Use when writing bio, updating LinkedIn summary, creating speaker bio, crafting press bio
3. **book-proposal** — Creates a non-fiction book proposal with chapter outline, hook, market analysis, and author platform. Use when writing book proposal, pitching publishers, planning non-fiction book, querying literary agents
4. **coaching-offer** — Structures a coaching or consulting offer with packaging, pricing, and positioning. Use when creating coaching program, structuring consulting offer, pricing services, packaging expertise
5. **conference-talk** — Creates a conference talk proposal with abstract, outline, and speaker notes. Use when submitting CFP, writing talk abstract, proposing conference session, preparing breakout talk
6. **digital-product-idea** — Ideates and validates digital product concepts from your expertise and audience needs. Use when creating digital product, building info product, launching online course idea, monetizing expertise
7. **linkedin-profile-optimizer** — Optimizes a LinkedIn profile for visibility, lead generation, and professional authority. Use when updating LinkedIn, optimizing profile, improving LinkedIn presence, generating leads on LinkedIn
8. **media-kit** — Creates a professional media kit for press, sponsors, and collaboration partners. Use when building media kit, press kit, sponsorship deck, influencer one-sheet, partnership materials
9. **newsletter-launch** — Plans a newsletter launch with positioning, platform selection, and first 10 issues. Use when starting a newsletter, launching email publication, building subscriber list, planning email content
10. **personal-brand-strategy** — Builds a complete personal brand strategy with positioning, content pillars, and audience targeting. Use when defining personal brand, creating brand strategy, positioning yourself as an expert, building online presence
11. **podcast-guest-pitch** — Writes a pitch to get booked as a guest on relevant podcasts. Use when pitching podcasts, getting on shows, podcast outreach, guest appearance booking
12. **portfolio-page** — Creates portfolio and personal website copy with project showcases and professional narrative. Use when building portfolio site, writing about page, creating personal website, showcasing work
13. **speaking-pitch** — Writes a pitch email to land speaking engagements at conferences and events. Use when pitching conferences, getting speaking gigs, submitting speaker applications, event outreach
14. **ted-talk-outline** — Outlines a TED-style talk with narrative arc, memorable moments, and audience transformation. Use when preparing TED talk, keynote speech, storytelling presentation, thought leadership talk
15. **thought-leadership-plan** — Creates a thought leadership plan with topics, channels, cadence, and measurement. Use when building thought leadership, planning expert content, establishing industry voice, growing professional influence

## 15. Analytics Data

1. **ab-test-plan** — Designs a rigorous A/B test plan with hypothesis, sample size, duration, and success criteria. Use when planning split tests, experiment design, or validating product changes
2. **attribution-model** — Designs a marketing attribution model for multi-channel tracking and budget optimization. Use when allocating ad spend, measuring channel ROI, or building multi-touch attribution
3. **cohort-analysis** — Sets up cohort analysis to understand retention and behavior patterns over time. Use when measuring retention curves, onboarding effectiveness, or comparing user groups by signup period
4. **competitive-benchmarking** — Creates a competitive benchmarking framework with data sources, metrics, and tracking cadence. Use when comparing performance against competitors, market positioning analysis, or building competitive intelligence dashboards
5. **conversion-funnel-analysis** — Analyzes conversion funnel to find and fix drop-off points with prioritized recommendations. Use when diagnosing funnel leaks, optimizing conversion rates, or mapping user journeys
6. **customer-lifetime-value** — Calculates and optimizes customer lifetime value with segmentation and actionable levers. Use when estimating CLV, LTV modeling, retention economics, or customer profitability analysis
7. **dashboard-design** — Designs an analytics dashboard with key metrics, layout, and drill-down logic. Use when building KPI dashboards, executive reporting views, or operational monitoring screens
8. **data-storytelling** — Turns raw data into a compelling narrative for stakeholders and decision-makers. Use when presenting analytics findings, building investor data decks, or communicating metrics to non-technical audiences
9. **kpi-framework** — Creates a KPI framework with metrics, targets, and reporting cadence for any business stage. Use when defining OKRs, setting metric targets, building scorecards, or aligning teams on what to measure
10. **survey-analysis** — Framework for analyzing survey data and extracting actionable insights. Use when interpreting NPS results, customer feedback surveys, market research data, or employee engagement scores
